/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.dongliu.requests.Cookie;
import net.dongliu.requests.CookieJar;
import net.dongliu.requests.Headers;
import net.dongliu.requests.HttpExecutor;
import net.dongliu.requests.NopHostnameVerifier;
import net.dongliu.requests.Parameter;
import net.dongliu.requests.RawResponse;
import net.dongliu.requests.Request;
import net.dongliu.requests.RequestBuilder;
import net.dongliu.requests.Requests;
import net.dongliu.requests.SSLSocketFactories;
import net.dongliu.requests.body.RequestBody;
import net.dongliu.requests.exception.RequestsException;
import net.dongliu.requests.exception.TooManyRedirectsException;
import net.dongliu.requests.utils.Cookies;
import net.dongliu.requests.utils.InputOutputs;

public class URLConnectionExecutor
implements HttpExecutor {
    @Override
    public RawResponse proceed(Request request) {
        RawResponse response = this.doRequest(request);
        int statusCode = response.getStatusCode();
        if (!request.isFollowRedirect() || !URLConnectionExecutor.isRedirect(statusCode)) {
            return response;
        }
        response.discardBody();
        int redirectTimes = 0;
        int maxRedirectTimes = 5;
        URL redirectUrl = request.getUrl();
        while (redirectTimes++ < maxRedirectTimes) {
            RequestBuilder builder;
            String location = response.getFirstHeader("Location");
            if (location == null) {
                throw new RequestsException("Redirect location not found");
            }
            try {
                redirectUrl = new URL(redirectUrl, location);
            }
            catch (MalformedURLException e) {
                throw new RequestsException("Resolve redirect url error, location: " + location, e);
            }
            String method = request.getMethod();
            RequestBody<?> body = request.getBody();
            if (statusCode == 301 || statusCode == 302 || statusCode == 303) {
                method = "GET";
                body = null;
            }
            if (!URLConnectionExecutor.isRedirect((response = (builder = Requests.newRequest(method, redirectUrl.toExternalForm()).cookieJar(request.getCookieJar()).socksTimeout(request.getSocksTimeout()).connectTimeout(request.getConnectTimeout()).basicAuth(request.getBasicAuth()).userAgent(request.getUserAgent()).compress(request.isCompress()).verify(request.isVerify()).certs(request.getCerts()).keepAlive(request.isKeepAlive()).followRedirect(false).proxy(request.getProxy()).body(body)).send()).getStatusCode())) {
                return response;
            }
            response.discardBody();
        }
        throw new TooManyRedirectsException(maxRedirectTimes);
    }

    private static boolean isRedirect(int status) {
        return status == 300 || status == 301 || status == 302 || status == 303 || status == 307 || status == 308;
    }

    private RawResponse doRequest(Request request) {
        HttpURLConnection conn;
        Charset charset = request.getCharset();
        URL url = request.getUrl();
        RequestBody<?> body = request.getBody();
        CookieJar cookieJar = request.getCookieJar();
        try {
            Proxy proxy = request.getProxy();
            conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        conn.setUseCaches(false);
        if (conn instanceof HttpsURLConnection) {
            SSLSocketFactory ssf = null;
            if (!request.isVerify()) {
                ssf = SSLSocketFactories.getTrustAllSSLSocketFactory();
                ((HttpsURLConnection)conn).setHostnameVerifier(NopHostnameVerifier.getInstance());
            } else if (!request.getCerts().isEmpty()) {
                ssf = SSLSocketFactories.getCustomSSLSocketFactory(request.getCerts());
            }
            if (ssf != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(ssf);
            }
        }
        try {
            conn.setRequestMethod(request.getMethod());
        }
        catch (ProtocolException e) {
            throw new RequestsException(e);
        }
        conn.setReadTimeout(request.getSocksTimeout());
        conn.setConnectTimeout(request.getConnectTimeout());
        conn.setInstanceFollowRedirects(false);
        if (body != null) {
            conn.setDoOutput(true);
            String contentType = body.getContentType();
            if (contentType != null) {
                if (body.isIncludeCharset()) {
                    contentType = contentType + "; charset=" + request.getCharset().name().toLowerCase();
                }
                conn.setRequestProperty("Content-Type", contentType);
            }
        }
        if (!request.getUserAgent().isEmpty()) {
            conn.setRequestProperty("User-Agent", request.getUserAgent());
        }
        if (request.isCompress()) {
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        if (request.getBasicAuth() != null) {
            conn.setRequestProperty("Authorization", request.getBasicAuth().encode());
        }
        List<Cookie> sessionCookies = cookieJar.getCookies(url);
        if (!request.getCookies().isEmpty() || !sessionCookies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, ?> entry : request.getCookies()) {
                sb.append(entry.getKey()).append("=").append(String.valueOf(entry.getValue())).append("; ");
            }
            for (Cookie cookie : sessionCookies) {
                sb.append(cookie.getName()).append("=").append(cookie.getValue()).append("; ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
                String string = sb.toString();
                conn.setRequestProperty("Cookie", string);
            }
        }
        for (Map.Entry entry : request.getHeaders()) {
            conn.setRequestProperty((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        if (!request.isKeepAlive()) {
            conn.setRequestProperty("Connection", "close");
        }
        try {
            conn.connect();
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        try {
            if (body != null) {
                this.sendBody(body, conn, charset);
            }
            return this.getResponse(url, conn, cookieJar, request.isCompress(), request.getMethod());
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            conn.disconnect();
        }
    }

    private RawResponse getResponse(URL url, HttpURLConnection conn, CookieJar cookieJar, boolean compress, String method) throws IOException {
        InputStream input;
        int status = conn.getResponseCode();
        String host = url.getHost().toLowerCase();
        String statusLine = null;
        ArrayList<Parameter<String>> headerList = new ArrayList<Parameter<String>>();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        int index = 0;
        while (true) {
            Cookie c;
            String key = conn.getHeaderFieldKey(index);
            String value = conn.getHeaderField(index);
            if (value == null) break;
            ++index;
            if (key == null) {
                statusLine = value;
                continue;
            }
            headerList.add(Parameter.of(key, value));
            if (!key.equalsIgnoreCase("Set-Cookie") || (c = Cookies.parseCookie(value, host, Cookies.calculatePath(url.getPath()))) == null) continue;
            cookies.add(c);
        }
        Headers headers = new Headers(headerList);
        try {
            input = conn.getInputStream();
        }
        catch (IOException e) {
            input = conn.getErrorStream();
        }
        if (input != null) {
            if (compress) {
                input = this.wrapCompressBody(status, method, headers, input);
            }
        } else {
            input = new ByteArrayInputStream(new byte[0]);
        }
        cookieJar.storeCookies(cookies);
        return new RawResponse(status, Objects.requireNonNull(statusLine), headers, cookies, input, conn);
    }

    private InputStream wrapCompressBody(int status, String method, Headers headers, InputStream input) throws IOException {
        if (method.equals("HEAD") || status >= 100 && status < 200 || status == 304 || status == 204) {
            return input;
        }
        String contentEncoding = headers.getFirstHeader("Content-Encoding");
        if (contentEncoding == null) {
            return input;
        }
        switch (contentEncoding) {
            case "gzip": {
                try {
                    return new GZIPInputStream(input);
                }
                catch (IOException e) {
                    InputOutputs.closeQuietly(input);
                    throw e;
                }
            }
            case "deflate": {
                return new InflaterInputStream(input, new Inflater(true));
            }
        }
        return input;
    }

    private void sendBody(RequestBody body, HttpURLConnection conn, Charset requestCharset) {
        try (OutputStream os = conn.getOutputStream();){
            body.writeBody(os, requestCharset);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
    }
}

