/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jdk.nashorn.internal.ir.annotations.Immutable;
import net.dongliu.requests.Cookie;
import net.dongliu.requests.Headers;
import net.dongliu.requests.Parameter;

@Immutable
public class Response<T> {
    private final int statusCode;
    private final List<Cookie> cookies;
    private final Headers headers;
    private final T body;

    public Response(int statusCode, List<Cookie> cookies, Headers headers, T body) {
        this.statusCode = statusCode;
        this.cookies = cookies;
        this.headers = headers;
        this.body = body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Nonnull
    public Collection<Cookie> getCookies() {
        return this.cookies;
    }

    @Nonnull
    public List<Parameter<String>> getHeaders() {
        return this.headers.getHeaders();
    }

    @Nullable
    public Cookie getFirstCookie(String name) {
        for (Cookie cookie : this.cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    @Nullable
    public String getFirstHeader(String name) {
        return this.headers.getFirstHeader(name);
    }

    @Nonnull
    public List<String> getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    public T getBody() {
        return this.body;
    }
}

