/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.InputStream;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dongliu.requests.BasicAuth;
import net.dongliu.requests.CertificateInfo;
import net.dongliu.requests.CookieJar;
import net.dongliu.requests.Interceptor;
import net.dongliu.requests.InterceptorChain;
import net.dongliu.requests.RawResponse;
import net.dongliu.requests.Request;
import net.dongliu.requests.URLConnectionExecutor;
import net.dongliu.requests.body.Part;
import net.dongliu.requests.body.RequestBody;

public final class RequestBuilder {
    String method = "GET";
    String url;
    Collection<? extends Map.Entry<String, ?>> headers = Collections.emptyList();
    Collection<? extends Map.Entry<String, ?>> cookies = Collections.emptyList();
    String userAgent = "Requests/Java " + System.getProperty("java.version");
    Collection<? extends Map.Entry<String, ?>> params = Collections.emptyList();
    Charset requestCharset = StandardCharsets.UTF_8;
    @Nullable
    RequestBody<?> body;
    int socksTimeout = 10000;
    int connectTimeout = 10000;
    @Nullable
    Proxy proxy;
    boolean followRedirect = true;
    boolean compress = true;
    boolean verify = true;
    List<CertificateInfo> certs = Collections.emptyList();
    BasicAuth basicAuth;
    @Nonnull
    CookieJar cookieJar;
    boolean keepAlive = true;
    private List<? extends Interceptor> interceptors = Collections.emptyList();

    RequestBuilder(CookieJar cookieJar) {
        this.cookieJar = Objects.requireNonNull(cookieJar);
    }

    public RequestBuilder method(String method) {
        this.method = Objects.requireNonNull(method);
        return this;
    }

    public RequestBuilder url(String url) {
        this.url = Objects.requireNonNull(url);
        return this;
    }

    public RequestBuilder headers(Collection<? extends Map.Entry<String, ?>> headers) {
        this.headers = headers;
        return this;
    }

    @SafeVarargs
    public final RequestBuilder headers(Map.Entry<String, ?> ... headers) {
        this.headers(Arrays.asList(headers));
        return this;
    }

    public final RequestBuilder headers(Map<String, ?> map) {
        this.headers = map.entrySet();
        return this;
    }

    public RequestBuilder cookies(Collection<? extends Map.Entry<String, ?>> cookies) {
        this.cookies = cookies;
        return this;
    }

    @SafeVarargs
    public final RequestBuilder cookies(Map.Entry<String, ?> ... cookies) {
        this.cookies(Arrays.asList(cookies));
        return this;
    }

    public final RequestBuilder cookies(Map<String, ?> map) {
        this.cookies = map.entrySet();
        return this;
    }

    public RequestBuilder userAgent(String userAgent) {
        this.userAgent = Objects.requireNonNull(userAgent);
        return this;
    }

    public RequestBuilder params(Collection<? extends Map.Entry<String, ?>> params) {
        this.params = params;
        return this;
    }

    @SafeVarargs
    public final RequestBuilder params(Map.Entry<String, ?> ... params) {
        this.params = Arrays.asList(params);
        return this;
    }

    public final RequestBuilder params(Map<String, ?> map) {
        this.params = map.entrySet();
        return this;
    }

    public RequestBuilder requestCharset(Charset charset) {
        this.requestCharset = charset;
        return this;
    }

    public RequestBuilder charset(Charset charset) {
        this.requestCharset = charset;
        return this;
    }

    public RequestBuilder body(@Nullable RequestBody<?> body) {
        this.body = body;
        return this;
    }

    @Deprecated
    public RequestBuilder forms(Collection<? extends Map.Entry<String, ?>> params) {
        this.body = RequestBody.form(params);
        return this;
    }

    @Deprecated
    @SafeVarargs
    public final RequestBuilder forms(Map.Entry<String, ?> ... formBody) {
        return this.forms(Arrays.asList(formBody));
    }

    @Deprecated
    public RequestBuilder forms(Map<String, ?> formBody) {
        return this.forms(formBody.entrySet());
    }

    public RequestBuilder body(Collection<? extends Map.Entry<String, ?>> params) {
        this.body = RequestBody.form(params);
        return this;
    }

    @SafeVarargs
    public final RequestBuilder body(Map.Entry<String, ?> ... formBody) {
        return this.body(Arrays.asList(formBody));
    }

    public RequestBuilder body(Map<String, ?> formBody) {
        return this.body(formBody.entrySet());
    }

    public RequestBuilder body(String str) {
        this.body = RequestBody.text(str);
        return this;
    }

    public RequestBuilder body(byte[] bytes) {
        this.body = RequestBody.bytes(bytes);
        return this;
    }

    public RequestBuilder body(InputStream input) {
        this.body = RequestBody.inputStream(input);
        return this;
    }

    public RequestBuilder jsonBody(Object value) {
        this.body = RequestBody.json(value);
        return this;
    }

    public RequestBuilder socksTimeout(int timeout) {
        RequestBuilder.checkTimeout(timeout);
        this.socksTimeout = timeout;
        return this;
    }

    public RequestBuilder connectTimeout(int timeout) {
        RequestBuilder.checkTimeout(timeout);
        this.connectTimeout = timeout;
        return this;
    }

    private static void checkTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout should not less than 0");
        }
    }

    public RequestBuilder proxy(@Nullable Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public RequestBuilder followRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
        return this;
    }

    public RequestBuilder compress(boolean compress) {
        this.compress = compress;
        return this;
    }

    public RequestBuilder verify(boolean verify) {
        this.verify = verify;
        return this;
    }

    public RequestBuilder keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public RequestBuilder certs(List<CertificateInfo> certs) {
        this.certs = Objects.requireNonNull(certs);
        return this;
    }

    public RequestBuilder basicAuth(String user, String password) {
        this.basicAuth = new BasicAuth(user, password);
        return this;
    }

    public RequestBuilder basicAuth(BasicAuth basicAuth) {
        this.basicAuth = basicAuth;
        return this;
    }

    Request build() {
        return new Request(this);
    }

    public RawResponse send() {
        Request request = this.build();
        URLConnectionExecutor executor = new URLConnectionExecutor();
        return new InterceptorChain(this.interceptors, executor).proceed(request);
    }

    public RequestBuilder timeout(int timeout) {
        RequestBuilder.checkTimeout(timeout);
        return this.connectTimeout(timeout).socksTimeout(timeout);
    }

    public final RequestBuilder multiPartBody(Part<?> ... parts) {
        return this.multiPartBody(Arrays.asList(parts));
    }

    public RequestBuilder multiPartBody(Collection<Part<?>> parts) {
        return this.body(RequestBody.multiPart(parts));
    }

    public RequestBuilder interceptors(List<? extends Interceptor> interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    public RequestBuilder interceptors(Interceptor ... interceptors) {
        return this.interceptors(Arrays.asList(interceptors));
    }

    public RequestBuilder cookieJar(CookieJar cookieJar) {
        this.cookieJar = Objects.requireNonNull(cookieJar);
        return this;
    }
}

