/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.dongliu.requests.Cookie;
import net.dongliu.requests.CookieJar;
import net.dongliu.requests.utils.Cookies;

@ThreadSafe
class DefaultCookieJar
implements CookieJar {
    private Map<CookieKey, Cookie> cookieMap = new HashMap<CookieKey, Cookie>();

    DefaultCookieJar() {
    }

    @Override
    public synchronized void storeCookies(Collection<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            CookieKey key = new CookieKey(cookie.getDomain(), cookie.getPath(), cookie.getName());
            this.cookieMap.put(key, cookie);
        }
        this.removeExpiredCookies();
    }

    private void removeExpiredCookies() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<CookieKey, Cookie>> iterator = this.cookieMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CookieKey, Cookie> entry = iterator.next();
            if (!entry.getValue().expired(now)) continue;
            iterator.remove();
        }
    }

    @Override
    @Nonnull
    public synchronized List<Cookie> getCookies(URL url) {
        long now = System.currentTimeMillis();
        ArrayList<Cookie> matched = new ArrayList<Cookie>();
        for (Cookie cookie : this.cookieMap.values()) {
            if (!Cookies.match(cookie, url.getProtocol(), url.getHost().toLowerCase(), url.getPath()) || cookie.expired(now)) continue;
            matched.add(cookie);
        }
        Collections.sort(matched, new Comparator<Cookie>(){

            @Override
            public int compare(Cookie cookie1, Cookie cookie2) {
                return cookie2.getPath().length() - cookie1.getPath().length();
            }
        });
        return matched;
    }

    @Override
    @Nonnull
    public synchronized Collection<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookieMap.values());
    }

    @Immutable
    private static class CookieKey {
        @Nonnull
        private final String domain;
        @Nonnull
        private final String path;
        @Nonnull
        private final String name;

        public CookieKey(String domain, String path, String name) {
            this.domain = domain;
            this.path = path;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CookieKey cookieKey = (CookieKey)o;
            if (!this.domain.equals(cookieKey.domain)) {
                return false;
            }
            if (!this.path.equals(cookieKey.path)) {
                return false;
            }
            return this.name.equals(cookieKey.name);
        }

        public int hashCode() {
            int result = this.domain.hashCode();
            result = 31 * result + this.path.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

