/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Cookie
implements Map.Entry<String, String>,
Serializable {
    @Nonnull
    private final String domain;
    @Nonnull
    private final String path;
    @Nonnull
    private final String name;
    @Nonnull
    private final String value;
    private final long expiry;
    private final boolean secure;
    private final boolean hostOnly;

    public Cookie(String domain, String path, String name, String value, long expiry, boolean secure, boolean hostOnly) {
        this.domain = Objects.requireNonNull(domain);
        this.path = Objects.requireNonNull(path);
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
        this.expiry = expiry;
        this.secure = secure;
        this.hostOnly = hostOnly;
    }

    @Nonnull
    public String getDomain() {
        return this.domain;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String value) {
        throw new UnsupportedOperationException();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public boolean expired(long now) {
        return this.expiry != 0L && this.expiry < now;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public boolean isHostOnly() {
        return this.hostOnly;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        if (this.expiry != cookie.expiry) {
            return false;
        }
        if (this.secure != cookie.secure) {
            return false;
        }
        if (this.hostOnly != cookie.hostOnly) {
            return false;
        }
        if (!this.domain.equals(cookie.domain)) {
            return false;
        }
        if (!this.path.equals(cookie.path)) {
            return false;
        }
        if (!this.name.equals(cookie.name)) {
            return false;
        }
        return this.value.equals(cookie.value);
    }

    @Override
    public int hashCode() {
        int result = this.domain.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + (int)(this.expiry ^ this.expiry >>> 32);
        result = 31 * result + (this.secure ? 1 : 0);
        result = 31 * result + (this.hostOnly ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Cookie{domain='" + this.domain + '\'' + ", path='" + this.path + '\'' + ", name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", expiry=" + this.expiry + ", secure=" + this.secure + ", hostOnly=" + this.hostOnly + '}';
    }
}

