/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.struct;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URLConnection;
import java.nio.file.Files;
import javax.annotation.Nullable;
import org.apache.http.annotation.Immutable;

@Immutable
public class Part {
    private final Type type;
    private final String name;
    @Nullable
    private final String mime;
    @Nullable
    private final String fileName;
    @Nullable
    private final File file;
    @Nullable
    private final InputStream in;
    @Nullable
    private final byte[] bytes;
    @Nullable
    private final String value;

    private Part(String name, String value) {
        this.file = null;
        this.mime = null;
        this.name = name;
        this.type = Type.TEXT;
        this.in = null;
        this.bytes = null;
        this.value = value;
        this.fileName = null;
    }

    private Part(String name, File file) {
        this(name, URLConnection.guessContentTypeFromName(file.getName()), file);
    }

    private Part(String name, String mime, File file) {
        this.file = file;
        this.mime = mime;
        this.name = name;
        this.type = Type.FILE;
        this.in = null;
        this.bytes = null;
        this.value = null;
        this.fileName = file.getName();
    }

    private Part(String name, String mime, String fileName, InputStream in) {
        this.file = null;
        this.in = in;
        this.bytes = null;
        this.mime = mime;
        this.name = name;
        this.type = Type.STREAM;
        this.value = null;
        this.fileName = fileName;
    }

    private Part(String name, String mime, String fileName, byte[] bytes) {
        this.file = null;
        this.in = null;
        this.bytes = bytes;
        this.mime = mime;
        this.name = name;
        this.type = Type.BYTES;
        this.value = null;
        this.fileName = fileName;
    }

    public static Part filePart(String fieldName, File file) {
        try {
            return new Part(fieldName, Files.probeContentType(file.toPath()), file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Part filePart(String name, String mime, String fileName, byte[] bytes) {
        return new Part(name, mime, fileName, bytes);
    }

    public static Part filePart(String name, String mime, String fileName, InputStream in) {
        return new Part(name, mime, fileName, in);
    }

    public static Part textPart(String name, String value) {
        return new Part(name, value);
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getMime() {
        return this.mime;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @Nullable
    public File getFile() {
        return this.file;
    }

    @Nullable
    public InputStream getIn() {
        return this.in;
    }

    @Nullable
    public byte[] getBytes() {
        return this.bytes;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public static enum Type {
        FILE,
        STREAM,
        BYTES,
        TEXT;

    }
}

