/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.struct;

import java.nio.charset.Charset;
import java.util.Collection;
import net.dongliu.requests.struct.HttpBody;
import net.dongliu.requests.struct.Part;
import org.apache.http.HttpEntity;
import org.apache.http.annotation.Immutable;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

@Immutable
public class MultiPartHttpBody
extends HttpBody<Collection<? extends Part>> {
    public MultiPartHttpBody(Collection<? extends Part> body) {
        super(body);
    }

    @Override
    public HttpEntity createEntity(Charset charset) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        for (Part f : (Collection)this.getBody()) {
            switch (f.getType()) {
                case TEXT: {
                    entityBuilder.addTextBody(f.getName(), f.getValue());
                    break;
                }
                case FILE: {
                    entityBuilder.addBinaryBody(f.getName(), f.getFile(), ContentType.create((String)f.getMime()), f.getFileName());
                    break;
                }
                case STREAM: {
                    entityBuilder.addBinaryBody(f.getName(), f.getIn(), ContentType.create((String)f.getMime()), f.getFileName());
                    break;
                }
                case BYTES: {
                    entityBuilder.addBinaryBody(f.getName(), f.getBytes(), ContentType.create((String)f.getMime()), f.getFileName());
                }
            }
        }
        return entityBuilder.build();
    }
}

