/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;

class TychoUtilities {
    private static final String TychoConstants_CTX_ECLIPSE_PLUGIN_CLASSPATH = "org.eclipse.tycho.core.TychoConstants/eclipsePluginClasspath";
    private static final Method getContextValueMethod;
    private static final Method getLocationsMethod;

    TychoUtilities() {
    }

    static List<String> addOsgiClasspathElements(MavenProject project, List<String> defaultClasspathElements) {
        if (getLocationsMethod == null) {
            return defaultClasspathElements;
        }
        List classpath = (List)TychoUtilities.getContextValue(project, TychoConstants_CTX_ECLIPSE_PLUGIN_CLASSPATH);
        if (classpath == null || classpath.isEmpty()) {
            return defaultClasspathElements;
        }
        ArrayList<String> osgiClasspath = new ArrayList<String>();
        for (Object classpathEntry : classpath) {
            for (File file : TychoUtilities.getLocations(classpathEntry)) {
                osgiClasspath.add(file.getAbsolutePath());
            }
        }
        osgiClasspath.addAll(defaultClasspathElements);
        return osgiClasspath;
    }

    private static Object getContextValue(MavenProject project, String key) {
        try {
            return getContextValueMethod.invoke((Object)project, key);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return Collections.emptyList();
        }
    }

    private static List<File> getLocations(Object classpathEntry) {
        try {
            return (List)getLocationsMethod.invoke(classpathEntry, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return Collections.emptyList();
        }
    }

    static {
        Method getContextValueMethod0 = null;
        Method getLocationsMethod0 = null;
        try {
            Class<MavenProject> mpClazz = MavenProject.class;
            getContextValueMethod0 = AccessController.doPrivileged(() -> {
                Method m = mpClazz.getDeclaredMethod("getContextValue", String.class);
                m.setAccessible(true);
                return m;
            });
            Class<?> cpeClazz = Class.forName("org.codehaus.tycho.ClasspathEntry");
            getLocationsMethod0 = AccessController.doPrivileged(() -> {
                Method m = cpeClazz.getDeclaredMethod("getLocations", new Class[0]);
                m.setAccessible(true);
                return m;
            });
        }
        catch (ClassNotFoundException | PrivilegedActionException exception) {
            // empty catch block
        }
        getContextValueMethod = getContextValueMethod0;
        getLocationsMethod = getLocationsMethod0;
    }
}

