/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.IpUtils;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthWeiboRequest
extends AuthDefaultRequest {
    public AuthWeiboRequest(AuthConfig config) {
        super(config, AuthSource.WEIBO);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HttpResponse response = this.doPostAuthorizationCode(authCallback.getCode());
        String accessTokenStr = response.body();
        JSONObject accessTokenObject = JSONObject.parseObject((String)accessTokenStr);
        if (accessTokenObject.containsKey((Object)"error")) {
            throw new AuthException(accessTokenObject.getString("error_description"));
        }
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).uid(accessTokenObject.getString("uid")).openId(accessTokenObject.getString("uid")).expireIn(accessTokenObject.getIntValue("expires_in")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        String uid = authToken.getUid();
        String oauthParam = String.format("uid=%s&access_token=%s", uid, accessToken);
        HttpResponse response = ((HttpRequest)((HttpRequest)HttpRequest.get((String)this.userInfoUrl(authToken)).header("Authorization", "OAuth2 " + oauthParam)).header("API-RemoteIP", IpUtils.getLocalIp())).execute();
        String userInfo = response.body();
        JSONObject object = JSONObject.parseObject((String)userInfo);
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error"));
        }
        return AuthUser.builder().uuid(object.getString("id")).username(object.getString("name")).avatar(object.getString("profile_image_url")).blog(StringUtils.isEmpty(object.getString("url")) ? "https://weibo.com/" + object.getString("profile_url") : object.getString("url")).nickname(object.getString("screen_name")).location(object.getString("location")).remark(object.getString("description")).gender(AuthUserGender.getRealGender(object.getString("gender"))).token(authToken).source(this.source).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("uid", authToken.getUid()).build();
    }
}

