/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthChecker;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;
import me.zhyd.oauth.utils.UuidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthDefaultRequest
implements AuthRequest {
    private static final Logger log = LoggerFactory.getLogger(AuthDefaultRequest.class);
    protected AuthConfig config;
    protected AuthSource source;

    public AuthDefaultRequest(AuthConfig config, AuthSource source) {
        this.config = config;
        this.source = source;
        if (!AuthChecker.isSupportedAuth(config, source)) {
            throw new AuthException(AuthResponseStatus.PARAMETER_INCOMPLETE);
        }
        AuthChecker.checkConfig(config, source);
    }

    protected abstract AuthToken getAccessToken(AuthCallback var1);

    protected abstract AuthUser getUserInfo(AuthToken var1);

    @Override
    public AuthResponse login(AuthCallback authCallback) {
        try {
            AuthChecker.checkCode(this.source == AuthSource.ALIPAY ? authCallback.getAuth_code() : authCallback.getCode());
            AuthChecker.checkState(authCallback.getState());
            AuthToken authToken = this.getAccessToken(authCallback);
            AuthUser user = this.getUserInfo(authToken);
            return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(user).build();
        }
        catch (Exception e) {
            log.error("Failed to login with oauth authorization.", (Throwable)e);
            return this.responseError(e);
        }
    }

    private AuthResponse responseError(Exception e) {
        int errorCode = AuthResponseStatus.FAILURE.getCode();
        if (e instanceof AuthException) {
            errorCode = ((AuthException)e).getErrorCode();
        }
        return AuthResponse.builder().code(errorCode).msg(e.getMessage()).build();
    }

    @Override
    @Deprecated
    public String authorize() {
        return this.authorize(null);
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("grant_type", "authorization_code").queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }

    protected String refreshTokenUrl(String refreshToken) {
        return UrlBuilder.fromBaseUrl(this.source.refresh()).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }

    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    protected String revokeUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.revoke()).queryParam("access_token", authToken.getAccessToken()).build();
    }

    protected String getRealState(String state) {
        if (StringUtils.isEmpty(state)) {
            state = UuidUtils.getUUID();
        }
        AuthStateCache.cache(state, state);
        return state;
    }

    protected HttpResponse doPostAuthorizationCode(String code) {
        return HttpRequest.post((String)this.accessTokenUrl(code)).execute();
    }

    protected HttpResponse doGetAuthorizationCode(String code) {
        return HttpRequest.get((String)this.accessTokenUrl(code)).execute();
    }

    @Deprecated
    protected HttpResponse doPostUserInfo(AuthToken authToken) {
        return HttpRequest.post((String)this.userInfoUrl(authToken)).execute();
    }

    protected HttpResponse doGetUserInfo(AuthToken authToken) {
        return HttpRequest.get((String)this.userInfoUrl(authToken)).execute();
    }

    @Deprecated
    protected HttpResponse doPostRevoke(AuthToken authToken) {
        return HttpRequest.post((String)this.revokeUrl(authToken)).execute();
    }

    protected HttpResponse doGetRevoke(AuthToken authToken) {
        return HttpRequest.get((String)this.revokeUrl(authToken)).execute();
    }
}

