/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.SqlOutParam;
import io.vertx.jdbcclient.impl.actions.JDBCQueryAction;
import io.vertx.jdbcclient.impl.actions.JDBCResponse;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collector;

public class JDBCPreparedQuery<C, R>
extends JDBCQueryAction<C, R> {
    private final ExtendedQueryCommand<R> query;
    private final Tuple params;
    private final List<Integer> outParams;

    private static List<Integer> countOut(Tuple tuple) {
        ArrayList<Integer> total = new ArrayList<Integer>();
        if (tuple != null) {
            for (int i = 0; i < tuple.size(); ++i) {
                if (!(tuple.getValue(i) instanceof SqlOutParam)) continue;
                total.add(i + 1);
            }
        }
        return total;
    }

    public JDBCPreparedQuery(JDBCStatementHelper helper, SQLOptions options, ExtendedQueryCommand<R> query, Collector<Row, C, R> collector, Tuple params) {
        super(helper, options, collector);
        this.query = query;
        this.params = params;
        this.outParams = JDBCPreparedQuery.countOut(params);
    }

    @Override
    public JDBCResponse<R> execute(Connection conn) throws SQLException {
        boolean returnAutoGeneratedKeys = this.outParams.size() == 0 && this.returnAutoGeneratedKeys(conn);
        try (PreparedStatement ps = this.prepare(conn, returnAutoGeneratedKeys);){
            this.fillStatement(ps, conn);
            JDBCResponse jDBCResponse = this.decode(ps, ps.execute(), returnAutoGeneratedKeys, this.outParams);
            return jDBCResponse;
        }
    }

    private PreparedStatement prepare(Connection conn, boolean returnAutoGeneratedKeys) throws SQLException {
        boolean autoGeneratedIndexes;
        String sql = this.query.sql();
        if (this.outParams.size() > 0) {
            return conn.prepareCall(sql);
        }
        boolean bl = autoGeneratedIndexes = this.options != null && this.options.getAutoGeneratedKeysIndexes() != null && this.options.getAutoGeneratedKeysIndexes().size() > 0;
        if (returnAutoGeneratedKeys && !autoGeneratedIndexes) {
            return conn.prepareStatement(sql, 1);
        }
        if (autoGeneratedIndexes) {
            JsonArray indexes = this.options.getAutoGeneratedKeysIndexes();
            try {
                if (indexes.getValue(0) instanceof Number) {
                    int[] keys = new int[indexes.size()];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = indexes.getInteger(i);
                    }
                    return conn.prepareStatement(sql, keys);
                }
                if (indexes.getValue(0) instanceof String) {
                    String[] keys = new String[indexes.size()];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = indexes.getString(i);
                    }
                    return conn.prepareStatement(sql, keys);
                }
                throw new SQLException("Invalid type of index, only [int, String] allowed");
            }
            catch (RuntimeException e) {
                throw new SQLException(e);
            }
        }
        return conn.prepareStatement(sql);
    }

    private void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
        for (int i = 0; i < this.params.size(); ++i) {
            Object value = this.adaptType(conn, this.params.getValue(i));
            if (value instanceof SqlOutParam) {
                SqlOutParam outValue = (SqlOutParam)value;
                if (outValue.in()) {
                    ps.setObject(i + 1, this.adaptType(conn, outValue.value()));
                }
                ((CallableStatement)ps).registerOutParameter(i + 1, outValue.type());
                continue;
            }
            ps.setObject(i + 1, value);
        }
    }

    private Object adaptType(Connection conn, Object value) throws SQLException {
        if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            return Time.valueOf(time);
        }
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return Date.valueOf(date);
        }
        if (value instanceof Instant) {
            Instant timestamp = (Instant)value;
            return Timestamp.from(timestamp);
        }
        if (value instanceof Buffer) {
            Buffer buffer = (Buffer)value;
            Blob blob = conn.createBlob();
            blob.setBytes(1L, buffer.getBytes());
            return blob;
        }
        return value;
    }
}

