/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.spi.impl;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import java.security.Principal;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import javax.sql.DataSource;

public class AgroalCPDataSourceProvider
implements DataSourceProvider {
    private JsonObject initConfig;

    @Override
    public DataSourceProvider init(JsonObject sqlConfig) {
        this.initConfig = sqlConfig;
        return this;
    }

    @Override
    public JsonObject getInitialConfig() {
        return Optional.ofNullable(this.initConfig).orElseGet(() -> DataSourceProvider.super.getInitialConfig());
    }

    @Override
    public int maximumPoolSize(DataSource dataSource, JsonObject config) throws SQLException {
        if (dataSource instanceof AgroalDataSource) {
            return ((AgroalDataSource)dataSource).getConfiguration().connectionPoolConfiguration().maxSize();
        }
        return -1;
    }

    @Override
    public DataSource getDataSource(JsonObject cfg) throws SQLException {
        JsonObject config = cfg == null || cfg.isEmpty() ? this.initConfig : cfg;
        AgroalDataSourceConfigurationSupplier dataSourceConfigurationBuilder = new AgroalDataSourceConfigurationSupplier().dataSourceImplementation(AgroalDataSourceConfiguration.DataSourceImplementation.valueOf((String)config.getString("dataSourceImplementation", "AGROAL"))).metricsEnabled(config.getBoolean("metricsEnabled", Boolean.valueOf(false)).booleanValue()).connectionPoolConfiguration(cp -> cp.validationTimeout(Duration.ofMillis(config.getLong("connectionValidationTimeout", Long.valueOf(30000L)))).minSize(config.getInteger("minSize", Integer.valueOf(0)).intValue()).maxSize(config.getInteger("maxSize", Integer.valueOf(30)).intValue()).initialSize(config.getInteger("initialSize", Integer.valueOf(1)).intValue()).acquisitionTimeout(Duration.ofMillis(config.getInteger("acquisitionTimeout", Integer.valueOf(0)).intValue())).reapTimeout(Duration.ofMillis(config.getLong("connectionReapTimeout", Long.valueOf(0L)))).leakTimeout(Duration.ofMillis(config.getLong("connectionLeakTimeout", Long.valueOf(0L)))).connectionFactoryConfiguration(cf -> cf.jdbcUrl(config.getString("jdbcUrl")).principal((Principal)new NamePrincipal(config.getString("principal"))).credential((Object)new SimplePassword(config.getString("credential")))));
        return AgroalDataSource.from((Supplier)dataSourceConfigurationBuilder, (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
    }

    @Override
    public void close(DataSource dataSource) throws SQLException {
        if (dataSource instanceof AgroalDataSource) {
            ((AgroalDataSource)dataSource).close();
        }
    }
}

