/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl;

import io.vertx.core.impl.TaskQueue;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;

class DataSourceHolder
implements Shareable {
    final TaskQueue creationQueue;
    final DataSourceProvider provider;
    final DataSource dataSource;
    final ExecutorService exec;
    final PoolMetrics metrics;
    final int refCount;

    DataSourceHolder(DataSourceProvider provider) {
        this(new TaskQueue(), provider, null, null, null, 1);
    }

    DataSourceHolder(DataSource dataSource, ExecutorService exec, PoolMetrics metrics) {
        this(null, null, dataSource, exec, metrics, 1);
    }

    private DataSourceHolder(TaskQueue creationQueue, DataSourceProvider provider, DataSource dataSource, ExecutorService exec, PoolMetrics metrics, int refCount) {
        if (dataSource != null) {
            Objects.requireNonNull(exec);
        } else {
            Objects.requireNonNull(creationQueue);
            Objects.requireNonNull(provider);
        }
        this.creationQueue = creationQueue;
        this.provider = provider;
        this.dataSource = dataSource;
        this.exec = exec;
        this.metrics = metrics;
        this.refCount = refCount;
    }

    DataSourceHolder created(DataSource dataSource, ExecutorService exec, PoolMetrics metrics) {
        Objects.requireNonNull(dataSource);
        Objects.requireNonNull(exec);
        if (this.dataSource != null) {
            throw new IllegalStateException();
        }
        return new DataSourceHolder(this.creationQueue, this.provider, dataSource, exec, metrics, this.refCount);
    }

    DataSourceHolder increment() {
        return new DataSourceHolder(this.creationQueue, this.provider, this.dataSource, this.exec, this.metrics, this.refCount + 1);
    }

    DataSourceHolder decrement() {
        if (this.refCount < 1) {
            throw new IllegalArgumentException();
        }
        return new DataSourceHolder(this.creationQueue, this.provider, this.dataSource, this.exec, this.metrics, this.refCount - 1);
    }
}

