/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;
import java.util.function.Predicate;

public class CompositeFutureImpl
implements CompositeFuture,
Handler<AsyncResult<CompositeFuture>> {
    private static final Predicate<CompositeFuture> ALL = cf -> {
        int size = cf.size();
        for (int i = 0; i < size; ++i) {
            if (cf.succeeded(i)) continue;
            return false;
        }
        return true;
    };
    private final Future[] results;
    private int count;
    private boolean completed;
    private Throwable cause;
    private Handler<AsyncResult<CompositeFuture>> handler;

    public static CompositeFuture all(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (int i = 0; i < len; ++i) {
            results[i].setHandler((AsyncResult<T> ar) -> {
                Handler<AsyncResult<CompositeFuture>> handler = null;
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        ++composite.count;
                        if (!composite.isComplete() && composite.count == len) {
                            handler = composite.setSucceeded();
                        }
                    }
                }
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    if (!composite.isComplete()) {
                        handler = composite.setFailed(ar.cause());
                    }
                }
                if (handler != null) {
                    handler.handle(composite);
                }
            });
        }
        if (len == 0) {
            composite.setSucceeded();
        }
        return composite;
    }

    public static CompositeFuture any(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (int i = 0; i < len; ++i) {
            results[i].setHandler((AsyncResult<T> ar) -> {
                Handler<AsyncResult<CompositeFuture>> handler = null;
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (!composite.isComplete()) {
                            handler = composite.setSucceeded();
                        }
                    }
                }
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    ++composite.count;
                    if (!composite.isComplete() && composite.count == len) {
                        handler = composite.setFailed(ar.cause());
                    }
                }
                if (handler != null) {
                    handler.handle(composite);
                }
            });
        }
        if (results.length == 0) {
            composite.setSucceeded();
        }
        return composite;
    }

    public static CompositeFuture join(Future<?> ... results) {
        return CompositeFutureImpl.join(ALL, results);
    }

    private static CompositeFuture join(Predicate<CompositeFuture> pred, Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (int i = 0; i < len; ++i) {
            results[i].setHandler((AsyncResult<T> ar) -> {
                Handler<AsyncResult<CompositeFuture>> handler = null;
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    ++composite.count;
                    if (!composite.isComplete() && composite.count == len) {
                        boolean completed = pred.test(composite);
                        handler = completed ? composite.setSucceeded() : composite.setFailed(new NoStackTraceThrowable("failed"));
                    }
                }
                if (handler != null) {
                    handler.handle(composite);
                }
            });
        }
        if (len == 0) {
            composite.setSucceeded();
        }
        return composite;
    }

    private CompositeFutureImpl(Future<?> ... results) {
        this.results = results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeFuture setHandler(Handler<AsyncResult<CompositeFuture>> handler) {
        boolean call;
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            this.handler = handler;
            call = this.completed;
        }
        if (call) {
            handler.handle(this);
        }
        return this;
    }

    @Override
    public Throwable cause(int index) {
        return this.future(index).cause();
    }

    @Override
    public boolean succeeded(int index) {
        return this.future(index).succeeded();
    }

    @Override
    public boolean failed(int index) {
        return this.future(index).failed();
    }

    @Override
    public boolean isComplete(int index) {
        return this.future(index).isComplete();
    }

    @Override
    public <T> T result(int index) {
        return this.future(index).result();
    }

    @Override
    public <T> T resultAt(int index) {
        return this.result(index);
    }

    private <T> Future<T> future(int index) {
        if (index < 0 || index > this.results.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.results[index];
    }

    @Override
    public int size() {
        return this.results.length;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.completed;
    }

    @Override
    public synchronized boolean succeeded() {
        return this.completed && this.cause == null;
    }

    @Override
    public synchronized boolean failed() {
        return this.completed && this.cause != null;
    }

    @Override
    public synchronized Throwable cause() {
        return this.completed && this.cause != null ? this.cause : null;
    }

    @Override
    public synchronized CompositeFuture result() {
        return this.completed && this.cause == null ? this : null;
    }

    @Override
    public void complete(CompositeFuture result) {
        Handler<AsyncResult<CompositeFuture>> handler = this.setSucceeded();
        if (handler != null) {
            handler.handle(this);
        }
    }

    @Override
    public void complete() {
        this.complete(null);
    }

    @Override
    public void fail(Throwable throwable) {
        Handler<AsyncResult<CompositeFuture>> handler = this.setFailed(throwable);
        if (handler != null) {
            handler.handle(this);
        }
    }

    @Override
    public void fail(String failureMessage) {
        this.fail(new NoStackTraceThrowable(failureMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<AsyncResult<CompositeFuture>> setFailed(Throwable cause) {
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            if (this.completed) {
                throw new IllegalStateException("Result is already complete: " + (this.cause == null ? "succeeded" : "failed"));
            }
            this.completed = true;
            this.cause = cause;
            return this.handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<AsyncResult<CompositeFuture>> setSucceeded() {
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            if (this.completed) {
                throw new IllegalStateException("Result is already complete: " + (this.cause == null ? "succeeded" : "failed"));
            }
            this.completed = true;
            return this.handler;
        }
    }

    @Override
    public Handler<AsyncResult<CompositeFuture>> completer() {
        return this;
    }

    @Override
    public void handle(AsyncResult<CompositeFuture> ar) {
        if (ar.succeeded()) {
            this.complete(this);
        } else {
            this.fail(ar.cause());
        }
    }
}

