/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.jar;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.aggregator.AggregatorBuildContext;
import io.takari.incrementalbuild.aggregator.InputAggregator;
import io.takari.incrementalbuild.aggregator.InputSet;
import io.takari.maven.plugins.TakariLifecycleMojo;
import io.takari.maven.plugins.TakariLifecycles;
import io.takari.maven.plugins.jar.AggregateSource;
import io.takari.maven.plugins.jar.ArchiveConfiguration;
import io.takari.maven.plugins.jar.BytesEntry;
import io.takari.maven.plugins.util.PropertiesWriter;
import io.tesla.proviso.archive.Archiver;
import io.tesla.proviso.archive.Entry;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.source.FileEntry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PACKAGE, configurator="takari", threadSafe=true)
public class Jar
extends TakariLifecycleMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classesDirectory;
    @Parameter(defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(defaultValue="true", property="mainJar")
    private boolean mainJar;
    @Parameter(defaultValue="false", property="sourceJar")
    private boolean sourceJar;
    @Parameter(defaultValue="false", property="testJar")
    private boolean testJar;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testClassesDirectory;
    @Parameter
    private ArchiveConfiguration archive;
    @Inject
    private AggregatorBuildContext buildContext;
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

    @Override
    protected void executeMojo() throws MojoExecutionException {
        boolean processingRequired;
        InputSet registeredOutput;
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdir();
        }
        if (this.mainJar) {
            File jar = new File(this.outputDirectory, String.format("%s.jar", this.finalName));
            registeredOutput = this.buildContext.newInputSet();
            try {
                if (this.classesDirectory.isDirectory()) {
                    this.classesDirectory = this.classesDirectory.getCanonicalFile();
                    Iterable inputs = registeredOutput.addInputs(this.classesDirectory, null, null);
                    this.logger.debug("Analyzing main classes directory {} with {} entries", (Object)this.classesDirectory, (Object)Iterables.size((Iterable)inputs));
                } else {
                    this.logger.warn("Main classes directory {} does not exist", (Object)this.classesDirectory);
                }
                boolean processingRequired2 = registeredOutput.aggregateIfNecessary(jar, new InputAggregator(){

                    public void aggregate(Output<File> output, Iterable<File> inputs) throws IOException {
                        Jar.this.logger.info("Building main JAR.");
                        ArrayList<Iterable> sources = new ArrayList<Iterable>();
                        if (Jar.this.archive != null && Jar.this.archive.getManifestFile() != null) {
                            sources.add(Jar.jarManifestSource(Jar.this.archive.getManifestFile()));
                        }
                        sources.add(Jar.this.inputsSource(Jar.this.classesDirectory, inputs));
                        sources.add(Collections.singleton(Jar.this.pomPropertiesSource(Jar.this.project)));
                        sources.add(Jar.this.jarManifestSource(Jar.this.project));
                        Jar.this.archive((File)output.getResource(), sources);
                    }
                });
                if (!processingRequired2) {
                    this.logger.info("Main JAR is up-to-date");
                }
                if (!TakariLifecycles.isJarProducingTakariLifecycle(this.project.getPackaging()) && this.alternateLifecycleProvidingPrimaryArtifact()) {
                    this.projectHelper.attachArtifact(this.project, "jar", jar);
                    this.logger.info("The '{}' lifecycle has indicated it will produce the primary artifact. Attaching JAR as a secondary artifact.", (Object)this.project.getPackaging());
                } else {
                    this.project.getArtifact().setFile(jar);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (this.sourceJar) {
            HashMultimap sources = HashMultimap.create();
            File sourceJar = new File(this.outputDirectory, String.format("%s-%s.jar", this.finalName, "sources"));
            InputSet registeredOutput2 = this.buildContext.newInputSet();
            try {
                for (String sourceRoot : this.project.getCompileSourceRoots()) {
                    File dir = new File(sourceRoot);
                    if (dir.isDirectory()) {
                        dir = dir.getCanonicalFile();
                        Iterable inputs = registeredOutput2.addInputs(dir, null, null);
                        this.logger.debug("Analyzing sources directory {} with {} entries", (Object)dir, (Object)Iterables.size((Iterable)inputs));
                        sources.putAll((Object)dir, inputs);
                        continue;
                    }
                    this.logger.debug("Sources directory {} does not exist", (Object)dir);
                }
                processingRequired = registeredOutput2.aggregateIfNecessary(sourceJar, new InputAggregator((Multimap)sources){
                    private final /* synthetic */ Multimap val$sources;
                    {
                        this.val$sources = multimap;
                    }

                    public void aggregate(Output<File> output, Iterable<File> inputs) throws IOException {
                        Jar.this.logger.info("Building source JAR.");
                        Jar.this.archive((File)output.getResource(), Arrays.asList(Jar.this.inputsSource((Multimap<File, File>)this.val$sources), Jar.this.jarManifestSource(Jar.this.project)));
                    }
                });
                if (!processingRequired) {
                    this.logger.info("Source JAR is up-to-date");
                }
                this.projectHelper.attachArtifact(this.project, "jar", "sources", sourceJar);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (this.testJar && this.testClassesDirectory.isDirectory()) {
            File testJar = new File(this.outputDirectory, String.format("%s-%s.jar", this.finalName, "tests"));
            registeredOutput = this.buildContext.newInputSet();
            try {
                this.testClassesDirectory = this.testClassesDirectory.getCanonicalFile();
                Iterable inputs = registeredOutput.addInputs(this.testClassesDirectory, null, null);
                this.logger.debug("Analyzing test classes directory {} with {} entries", (Object)this.testClassesDirectory, (Object)Iterables.size((Iterable)inputs));
                processingRequired = registeredOutput.aggregateIfNecessary(testJar, new InputAggregator(){

                    public void aggregate(Output<File> output, Iterable<File> inputs) throws IOException {
                        Jar.this.logger.info("Building test JAR.");
                        Jar.this.archive((File)output.getResource(), Arrays.asList(Jar.this.inputsSource(Jar.this.testClassesDirectory, inputs), Jar.this.jarManifestSource(Jar.this.project)));
                    }
                });
                if (!processingRequired) {
                    this.logger.info("Test JAR is up-to-date");
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            this.projectHelper.attachArtifact(this.project, "jar", "tests", testJar);
        }
    }

    private void archive(File jar, List<Iterable<Entry>> sources) throws IOException {
        Archiver archiver = Archiver.builder().useRoot(false).normalize(true).build();
        archiver.archive(jar, new Source[]{new AggregateSource(sources)});
        if (this.logger.isDebugEnabled()) {
            int size = 0;
            for (Iterable<Entry> source : sources) {
                size += Iterables.size(source);
            }
            this.logger.debug("Created archive {} with {} entries", (Object)jar, (Object)size);
        }
    }

    static String getRelativePath(File basedir, File resource) {
        return basedir.toPath().relativize(resource.toPath()).toString().replace('\\', '/');
    }

    private List<Entry> inputsSource(Multimap<File, File> inputs) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (File basedir : inputs.keySet()) {
            entries.addAll(this.inputsSource(basedir, inputs.get((Object)basedir)));
        }
        return entries;
    }

    private List<Entry> inputsSource(File basedir, Iterable<File> inputs) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (File input : inputs) {
            String entryName = Jar.getRelativePath(basedir, input);
            entries.add((Entry)new FileEntry(entryName, input));
        }
        return entries;
    }

    public static Iterable<Entry> jarManifestSource(File file) {
        return Collections.singleton(new FileEntry(MANIFEST_PATH, file));
    }

    private Iterable<Entry> jarManifestSource(MavenProject project) throws IOException {
        File manifestFile;
        Manifest manifest = new Manifest();
        Attributes main = manifest.getMainAttributes();
        main.putValue("Manifest-Version", "1.0");
        main.putValue("Archiver-Version", "Provisio Archiver");
        main.putValue("Created-By", "Takari Inc.");
        main.putValue("Built-By", System.getProperty("user.name"));
        main.putValue("Build-Jdk", System.getProperty("java.version"));
        main.putValue("Specification-Title", project.getArtifactId());
        main.putValue("Specification-Version", project.getVersion());
        main.putValue("Implementation-Title", project.getArtifactId());
        main.putValue("Implementation-Version", project.getVersion());
        main.putValue("Implementation-Vendor-Id", project.getGroupId());
        if (this.archive != null && this.archive.getManifestEntries() != null) {
            for (Map.Entry<String, String> extra : this.archive.getManifestEntries().entrySet()) {
                if (extra.getValue() == null) continue;
                main.putValue(extra.getKey(), extra.getValue());
            }
        }
        if (!(manifestFile = new File(project.getBuild().getDirectory(), "MANIFEST.MF")).getParentFile().exists()) {
            manifestFile.getParentFile().mkdirs();
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        manifest.write(buf);
        return Collections.singleton(new BytesEntry(MANIFEST_PATH, buf.toByteArray()));
    }

    protected Entry pomPropertiesSource(MavenProject project) throws IOException {
        String entryName = String.format("META-INF/maven/%s/%s/pom.properties", project.getGroupId(), project.getArtifactId());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        Properties properties = new Properties();
        properties.setProperty("groupId", project.getGroupId());
        properties.setProperty("artifactId", project.getArtifactId());
        properties.setProperty("version", project.getVersion());
        PropertiesWriter.write(properties, null, (OutputStream)buf);
        return new BytesEntry(entryName, buf.toByteArray());
    }
}

