/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import com.google.common.collect.ImmutableSet;
import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.spi.DefaultOutput;
import io.takari.maven.plugins.compile.CompilerBuildContext;
import io.takari.maven.plugins.compile.jdt.CompilerJdt;
import io.takari.maven.plugins.compile.jdt.ProcessingEnvImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.ForwardingFileObject;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;

class FilerImpl
implements Filer {
    private final CompilerBuildContext context;
    private final StandardJavaFileManager fileManager;
    private final ProcessingEnvImpl processingEnv;
    private final CompilerJdt incrementalCompiler;
    private final Set<URI> createdResources = new HashSet<URI>();
    private final Set<File> writtenFiles = new HashSet<File>();

    public FilerImpl(CompilerBuildContext context, StandardJavaFileManager fileManager, CompilerJdt incrementalCompiler, ProcessingEnvImpl processingEnv) {
        this.context = context;
        this.fileManager = fileManager;
        this.incrementalCompiler = incrementalCompiler;
        this.processingEnv = processingEnv;
    }

    @Override
    public JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        JavaFileObject sourceFile = this.fileManager.getJavaFileForOutput(StandardLocation.SOURCE_OUTPUT, name.toString(), JavaFileObject.Kind.SOURCE, null);
        if (!this.createdResources.add(sourceFile.toUri())) {
            throw new FilerException("Attempt to recreate file for type " + name);
        }
        return new JavaFileObjectImpl(sourceFile, new FileObjectDelegate(this){
            private boolean closed;
            {
                this.closed = false;
            }

            @Override
            protected void onClose(Output<File> generatedSource) {
                if (!this.closed) {
                    this.closed = true;
                    CompilationUnit unit = new CompilationUnit(null, ((File)generatedSource.getResource()).getAbsolutePath(), null);
                    processingEnv.addNewUnit((ICompilationUnit)unit);
                    incrementalCompiler.addGeneratedSource(generatedSource);
                }
            }
        });
    }

    @Override
    public JavaFileObject createClassFile(CharSequence name, Element ... originatingElements) throws IOException {
        JavaFileObject classFile = this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, name.toString(), JavaFileObject.Kind.CLASS, null);
        if (!this.createdResources.add(classFile.toUri())) {
            throw new FilerException("Attempt to recreate file for class " + name);
        }
        return new JavaFileObjectImpl(classFile, new FileObjectDelegate(this){

            @Override
            protected void onClose(Output<File> generatedClass) {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
        FileObject file = this.fileManager.getFileForOutput(location, pkg.toString(), relativeName.toString(), null);
        if (!this.createdResources.add(file.toUri())) {
            throw new FilerException("Attempt to recreate file for resource " + pkg + "." + relativeName);
        }
        return new FileObjectImpl(file, new FileObjectDelegate(null, null));
    }

    @Override
    public FileObject getResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName) throws IOException {
        FileObject file = this.fileManager.getFileForInput(location, pkg.toString(), relativeName.toString());
        if (file == null) {
            throw new FileNotFoundException("Resource does not exist " + location + '/' + pkg + '/' + relativeName);
        }
        if (this.createdResources.contains(file.toUri())) {
            throw new FilerException("Resource already created " + pkg + "." + relativeName);
        }
        return file;
    }

    public void incrementalIterationReset() {
        this.createdResources.clear();
    }

    public Set<File> getWrittenFiles() {
        return ImmutableSet.copyOf(this.writtenFiles);
    }

    private class FileObjectDelegate {
        private FileObjectDelegate() {
        }

        public OutputStream openOutputStream(URI uri) throws IOException {
            File outputFile = new File(uri);
            FilerImpl.this.writtenFiles.add(outputFile);
            DefaultOutput output = FilerImpl.this.context.processOutput(outputFile);
            return new FilterOutputStream(output.newOutputStream(), (Output)output){
                private final /* synthetic */ Output val$output;
                {
                    this.val$output = output;
                    super($anonymous0);
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    FileObjectDelegate.this.onClose((Output<File>)this.val$output);
                }
            };
        }

        public Writer openWriter(URI uri) throws IOException {
            return new OutputStreamWriter(this.openOutputStream(uri));
        }

        protected void onClose(Output<File> output) {
        }

        /* synthetic */ FileObjectDelegate(FileObjectDelegate fileObjectDelegate, FileObjectDelegate fileObjectDelegate2) {
            this();
        }
    }

    private static class FileObjectImpl
    extends ForwardingFileObject<FileObject> {
        private final FileObjectDelegate delegate;

        protected FileObjectImpl(FileObject fileObject, FileObjectDelegate delegate) {
            super(fileObject);
            this.delegate = delegate;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.delegate.openOutputStream(this.toUri());
        }

        @Override
        public Writer openWriter() throws IOException {
            return this.delegate.openWriter(this.toUri());
        }
    }

    private static class JavaFileObjectImpl
    extends ForwardingJavaFileObject<JavaFileObject> {
        private final FileObjectDelegate delegate;

        public JavaFileObjectImpl(JavaFileObject fileObject, FileObjectDelegate delegate) {
            super(fileObject);
            this.delegate = delegate;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.delegate.openOutputStream(this.toUri());
        }

        @Override
        public Writer openWriter() throws IOException {
            return this.delegate.openWriter(this.toUri());
        }
    }
}

