/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.maven.Maven;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="update-check", threadSafe=true)
public class UpdateCheckMojo
extends AbstractMojo {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String REMOTE_URL = "https://update.takari.io/latest/takari-lifecycle";
    public static final String GROUP_ID = "io.takari.maven.plugins";
    public static final String ARTIFACT_ID = "takari-lifecycle-plugin";
    public static final long ONE_WEEK_MS = TimeUnit.DAYS.toMillis(7L);
    public static final String UPDATE_CHECK_TIMESTAMP_PREF = "updateCheckTimestamp";
    public static final int UPDATE_TIMEOUT_MS = 30000;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String version = this.getLocalVersion(((Object)((Object)this)).getClass().getClassLoader(), GROUP_ID, ARTIFACT_ID);
            if (version == null) {
                this.log.debug("Could not determine {}:{} version, skipping update check", (Object)GROUP_ID, (Object)ARTIFACT_ID);
                return;
            }
            Preferences preferences = Preferences.userRoot().node(GROUP_ID.replace('.', '/')).node(ARTIFACT_ID).node(version.toString());
            long timestamp = System.currentTimeMillis();
            if (timestamp - preferences.getLong(UPDATE_CHECK_TIMESTAMP_PREF, 0L) < ONE_WEEK_MS) {
                return;
            }
            preferences.putLong(UPDATE_CHECK_TIMESTAMP_PREF, timestamp);
            preferences.flush();
            String mavenVersion = this.getLocalVersion(Maven.class.getClassLoader(), "org.apache.maven", "maven-core");
            String javaVersion = System.getProperty("java.version");
            String query = String.format("m=%s&j=%s", mavenVersion, javaVersion);
            URLConnection conn = new URL("https://update.takari.io/latest/takari-lifecycle?" + query).openConnection();
            conn.addRequestProperty("User-Agent", "takari-lifecycle/" + version.toString());
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            Throwable throwable = null;
            Object var10_10 = null;
            try (InputStream is = conn.getInputStream();){
                String latestVersion = this.getVersion(is);
                if (latestVersion != null && new DefaultArtifactVersion(version).compareTo((ArtifactVersion)new DefaultArtifactVersion(latestVersion)) < 0) {
                    this.log.warn("Takari Lifecycle version {} is outdated, consider upgrade to {}", (Object)version, (Object)latestVersion);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | BackingStoreException exception) {}
    }

    private String getLocalVersion(ClassLoader loader, String groupId, String artifactId) throws IOException {
        String path = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream is = loader.getResourceAsStream(path);){
            String string = is != null ? this.getVersion(is) : null;
            return string;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getVersion(InputStream is) throws IOException {
        Properties p = new Properties();
        p.load(is);
        return p.getProperty("version");
    }
}

