/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import io.takari.maven.plugins.compile.jdt.ProcessingEnvImpl;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnnotationProcessorManager
extends BaseAnnotationProcessorManager {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ResettableProcessorIterator processors;
    private boolean finished;

    public AnnotationProcessorManager(ProcessingEnvImpl processingEnv, StandardJavaFileManager fileManager, String[] processors) {
        this._processingEnv = processingEnv;
        ClassLoader procLoader = fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        this.processors = processors != null ? new SpecifiedProcessors(procLoader, processors) : new DiscoveredProcessors(procLoader);
    }

    public ProcessorInfo discoverNextProcessor() {
        if (this.processors.hasNext()) {
            Processor processor = (Processor)this.processors.next();
            processor.init((ProcessingEnvironment)this._processingEnv);
            ProcessorInfo procecssorInfo = new ProcessorInfo(processor);
            this._processors.add(procecssorInfo);
            return procecssorInfo;
        }
        return null;
    }

    public void reportProcessorException(Processor p, Exception e) {
        throw new AbortCompilation(null, (Throwable)e);
    }

    public void processAnnotations(CompilationUnitDeclaration[] units, ReferenceBinding[] referenceBindings, boolean isLastRound) {
        if (this.finished) {
            this.logger.warn("Suppressed duplicate processingOver==true annotation processor invocation, see Eclipse bug 468893");
            return;
        }
        this.finished = isLastRound;
        super.processAnnotations(units, referenceBindings, isLastRound);
    }

    public void hardReset() {
        ((ProcessingEnvImpl)this._processingEnv).hardReset();
        this._processors.clear();
        this._isFirstRound = true;
        this._round = 0;
        this.processors.reset();
        this.finished = false;
    }

    private static class DiscoveredProcessors
    implements ResettableProcessorIterator {
        private final ServiceLoader<Processor> loader;
        private Iterator<Processor> iterator;

        public DiscoveredProcessors(ClassLoader procLoader) {
            this.loader = ServiceLoader.load(Processor.class, procLoader);
            this.iterator = this.loader.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Processor next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.iterator = this.loader.iterator();
        }
    }

    private static interface ResettableProcessorIterator
    extends Iterator<Processor> {
        public void reset();
    }

    private static class SpecifiedProcessors
    implements ResettableProcessorIterator {
        private final ClassLoader loader;
        private final String[] processors;
        private int idx;

        public SpecifiedProcessors(ClassLoader loader, String[] processors) {
            this.loader = loader;
            this.processors = processors;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.processors.length;
        }

        @Override
        public Processor next() {
            try {
                return (Processor)this.loader.loadClass(this.processors[this.idx++]).newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new AbortCompilation(null, (Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.idx = 0;
        }
    }
}

