/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleServiceImpl;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetails;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetailsServiceImpl;
import com.alibaba.nacos.plugin.auth.impl.utils.PasswordEncoderUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class LdapAuthenticationProvider
implements AuthenticationProvider {
    private static final String DEFAULT_PASSWORD = "nacos";
    private static final String LDAP_PREFIX = "LDAP_";
    private final NacosUserDetailsServiceImpl userDetailsService;
    private final NacosRoleServiceImpl nacosRoleService;
    private final LdapTemplate ldapTemplate;
    private final String filterPrefix;
    private final boolean caseSensitive;

    public LdapAuthenticationProvider(LdapTemplate ldapTemplate, NacosUserDetailsServiceImpl userDetailsService, NacosRoleServiceImpl nacosRoleService, String filterPrefix, boolean caseSensitive) {
        this.ldapTemplate = ldapTemplate;
        this.nacosRoleService = nacosRoleService;
        this.userDetailsService = userDetailsService;
        this.filterPrefix = filterPrefix;
        this.caseSensitive = caseSensitive;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UserDetails userDetails;
        String username = (String)authentication.getPrincipal();
        String password = (String)authentication.getCredentials();
        if (this.isAdmin(username)) {
            UserDetails userDetails2 = this.userDetailsService.loadUserByUsername(username);
            if (PasswordEncoderUtil.matches(password, userDetails2.getPassword()).booleanValue()) {
                return new UsernamePasswordAuthenticationToken((Object)userDetails2, (Object)password, userDetails2.getAuthorities());
            }
            return null;
        }
        if (!this.caseSensitive) {
            username = StringUtils.lowerCase((String)username);
        }
        try {
            if (!this.ldapLogin(username, password)) {
                return null;
            }
        }
        catch (Exception e) {
            Loggers.AUTH.error("[LDAP-LOGIN] failed", (Throwable)e);
            return null;
        }
        try {
            userDetails = this.userDetailsService.loadUserByUsername(LDAP_PREFIX + username);
        }
        catch (UsernameNotFoundException exception) {
            String nacosPassword = PasswordEncoderUtil.encode(DEFAULT_PASSWORD);
            this.userDetailsService.createUser(LDAP_PREFIX + username, nacosPassword);
            User user = new User();
            user.setUsername(LDAP_PREFIX + username);
            user.setPassword(nacosPassword);
            userDetails = new NacosUserDetails(user);
        }
        return new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)password, userDetails.getAuthorities());
    }

    private boolean isAdmin(String username) {
        List<RoleInfo> roleInfos = this.nacosRoleService.getRoles(username);
        if (CollectionUtils.isEmpty(roleInfos)) {
            return false;
        }
        for (RoleInfo roleinfo : roleInfos) {
            if (!"ROLE_ADMIN".equals(roleinfo.getRole())) continue;
            return true;
        }
        return false;
    }

    private boolean ldapLogin(String username, String password) throws AuthenticationException {
        return this.ldapTemplate.authenticate("", "(" + this.filterPrefix + "=" + username + ")", password);
    }

    public boolean supports(Class<?> aClass) {
        return aClass.equals(UsernamePasswordAuthenticationToken.class);
    }
}

