/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl;

import com.alibaba.nacos.common.event.ServerConfigChangeEvent;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.plugin.auth.impl.constant.AuthConstants;
import com.alibaba.nacos.sys.env.EnvUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenManager
extends Subscriber<ServerConfigChangeEvent> {
    private static final String AUTHORITIES_KEY = "auth";
    private volatile long tokenValidityInSeconds;
    private volatile JwtParser jwtParser;
    private volatile SecretKey secretKey;

    public JwtTokenManager() {
        NotifyCenter.registerSubscriber((Subscriber)this);
        this.processProperties();
    }

    private void processProperties() {
        this.tokenValidityInSeconds = (Long)EnvUtil.getProperty((String)"nacos.core.auth.plugin.nacos.token.expire.seconds", Long.class, (Object)AuthConstants.DEFAULT_TOKEN_EXPIRE_SECONDS);
        String encodedSecretKey = EnvUtil.getProperty((String)"nacos.core.auth.plugin.nacos.token.secret.key", (String)"");
        try {
            this.secretKey = Keys.hmacShaKeyFor((byte[])((byte[])Decoders.BASE64.decode((Object)encodedSecretKey)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the length of  must great than or equal 32 bytes; And the secret key  must be encoded by base64", e);
        }
        this.jwtParser = Jwts.parserBuilder().setSigningKey((Key)this.secretKey).build();
    }

    public String createToken(Authentication authentication) {
        return this.createToken(authentication.getName());
    }

    public String createToken(String userName) {
        Date validity = new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.getTokenValidityInSeconds()));
        Claims claims = Jwts.claims().setSubject(userName);
        return Jwts.builder().setClaims(claims).setExpiration(validity).signWith((Key)this.secretKey, SignatureAlgorithm.HS256).compact();
    }

    public Authentication getAuthentication(String token) {
        Claims claims = (Claims)this.jwtParser.parseClaimsJws(token).getBody();
        List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)((String)claims.get((Object)AUTHORITIES_KEY)));
        User principal = new User(claims.getSubject(), "", (Collection)authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)"", (Collection)authorities);
    }

    public void validateToken(String token) {
        this.jwtParser.parseClaimsJws(token);
    }

    public long getTokenValidityInSeconds() {
        return this.tokenValidityInSeconds;
    }

    public void onEvent(ServerConfigChangeEvent event) {
        this.processProperties();
    }

    public Class<? extends Event> subscribeType() {
        return ServerConfigChangeEvent.class;
    }
}

