/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute;

import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckType;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataOperateService;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteContent;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteDelayTaskEngine;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.ServiceChangeV1Task;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.selector.NoneSelector;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Map;

public class DoubleWriteMetadataChangeToV2Task
extends AbstractExecuteTask {
    private final Service service;
    private final ServiceMetadata serviceMetadata;
    private static final int PORT = 80;

    public DoubleWriteMetadataChangeToV2Task(String namespace, String serviceName, boolean ephemeral, ServiceMetadata serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
        String groupName = NamingUtils.getGroupName((String)serviceName);
        String serviceNameWithoutGroup = NamingUtils.getServiceName((String)serviceName);
        this.service = Service.newService(namespace, groupName, serviceNameWithoutGroup, ephemeral);
    }

    public void run() {
        try {
            NamingMetadataOperateService metadataOperate = (NamingMetadataOperateService)ApplicationUtils.getBean(NamingMetadataOperateService.class);
            if (!this.isDefaultServiceMetadata()) {
                metadataOperate.updateServiceMetadata(this.service, this.serviceMetadata);
            }
            for (Map.Entry<String, ClusterMetadata> entry : this.serviceMetadata.getClusters().entrySet()) {
                if (this.isDefaultClusterMetadata(entry.getValue())) continue;
                metadataOperate.addClusterMetadata(this.service, entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("Double write task for {} metadata from 1 to 2 failed", (Object)this.service, (Object)e);
            }
            ServiceChangeV1Task retryTask = new ServiceChangeV1Task(this.service.getNamespace(), this.service.getGroupedServiceName(), this.service.isEphemeral(), DoubleWriteContent.METADATA);
            retryTask.setTaskInterval(3000L);
            String taskKey = ServiceChangeV1Task.getKey(this.service.getNamespace(), this.service.getGroupedServiceName(), this.service.isEphemeral());
            ((DoubleWriteDelayTaskEngine)((Object)ApplicationUtils.getBean(DoubleWriteDelayTaskEngine.class))).addTask(taskKey, retryTask);
        }
    }

    private boolean isDefaultServiceMetadata() {
        return this.serviceMetadata.getExtendData().isEmpty() && this.serviceMetadata.getProtectThreshold() == 0.0f && this.serviceMetadata.getSelector() instanceof NoneSelector && this.serviceMetadata.isEphemeral();
    }

    private boolean isDefaultClusterMetadata(ClusterMetadata metadata) {
        return HealthCheckType.TCP.name().equals(metadata.getHealthyCheckType()) && metadata.getExtendData().isEmpty() && metadata.getHealthyCheckPort() == 80 && metadata.isUseInstancePortForCheck();
    }
}

