/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.ruleactivator;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.configs.ControlConfigs;
import com.alibaba.nacos.plugin.control.ruleactivator.NacosRuleParser;
import com.alibaba.nacos.plugin.control.ruleactivator.RuleParser;
import java.util.Collection;
import org.slf4j.Logger;

public class RuleParserProxy {
    private static final Logger LOGGER = Loggers.CONTROL;
    private static RuleParser instance;

    public static RuleParser getInstance() {
        return instance;
    }

    static {
        Collection ruleParsers = NacosServiceLoader.load(RuleParser.class);
        String ruleParserName = ControlConfigs.getInstance().getRuleParser();
        for (RuleParser ruleParser : ruleParsers) {
            if (!ruleParser.getName().equalsIgnoreCase(ruleParserName)) continue;
            LOGGER.info("Found  rule parser of name={},class={}", (Object)ruleParserName, (Object)ruleParser.getClass().getSimpleName());
            instance = ruleParser;
            break;
        }
        if (instance == null) {
            LOGGER.warn("Fail to rule parser of name \uff1a" + ruleParserName);
            instance = new NacosRuleParser();
        }
    }
}

