/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.app;

import io.smallrye.metrics.app.Clock;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.microprofile.metrics.SimpleTimer;

public class SimpleTimerImpl
implements SimpleTimer {
    private final Clock clock;
    private final LongAdder count;
    private final LongAdder elapsedTime;

    public SimpleTimerImpl() {
        this(Clock.defaultClock());
    }

    public SimpleTimerImpl(Clock clock) {
        this.clock = clock;
        this.count = new LongAdder();
        this.elapsedTime = new LongAdder();
    }

    public void update(Duration duration) {
        this.update(duration.toNanos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(Runnable event) {
        long startTime = this.clock.getTick();
        try {
            event.run();
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    public Context time() {
        return new Context(this, this.clock);
    }

    public Duration getElapsedTime() {
        return Duration.ofNanos(this.elapsedTime.sum());
    }

    public long getCount() {
        return this.count.sum();
    }

    private void update(long duration) {
        if (duration >= 0L) {
            this.count.increment();
            this.elapsedTime.add(duration);
        }
    }

    public static class Context
    implements SimpleTimer.Context {
        private final SimpleTimerImpl timer;
        private final Clock clock;
        private final long startTime;

        private Context(SimpleTimerImpl timer, Clock clock) {
            this.timer = timer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.timer.update(Duration.ofNanos(elapsed));
            return elapsed;
        }

        public void close() {
            this.stop();
        }
    }
}

