/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.jandex.ClassSummary;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.maven.ArchiveScanner;

@Mojo(name="jandex-jar", threadSafe=true)
public class JandexJarGoal
extends AbstractMojo {
    @Parameter(required=true)
    private File jar;
    @Parameter(defaultValue="META-INF/jandex.idx")
    private String indexName;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;
    @Parameter(defaultValue="true")
    private boolean useDefaultExcludes;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(property="jandex.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Jandex execution skipped");
            return;
        }
        if (!this.jar.isFile()) {
            this.getLog().warn((CharSequence)("Skipping, expected JAR does not exist or is not a file: " + this.jar));
            return;
        }
        Index index = this.indexJar();
        this.getLog().info((CharSequence)("Saving Jandex index into JAR: " + this.jar));
        Path tmp = this.createTempFile("jandextmp");
        try (ZipFile zip = new ZipFile(this.jar);
             ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(tmp.toFile().toPath(), new OpenOption[0]));){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || entry.getName().equals(this.indexName)) continue;
                ZipEntry newEntry = new ZipEntry(entry);
                if (newEntry.getMethod() != 0) {
                    newEntry.setCompressedSize(-1L);
                }
                out.putNextEntry(newEntry);
                InputStream in = zip.getInputStream(entry);
                try {
                    JandexJarGoal.copy(in, out);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            out.putNextEntry(new ZipEntry(this.indexName));
            new IndexWriter((OutputStream)out).write(index);
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(tmp);
            }
            catch (IOException e1) {
                e.addSuppressed(e1);
            }
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        Path originalJar = this.jar.toPath();
        Path backupJar = this.createTempFile("jandexbackup");
        try {
            Files.move(originalJar, backupJar, StandardCopyOption.REPLACE_EXISTING);
            Files.move(tmp, originalJar, new CopyOption[0]);
            Files.delete(backupJar);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private Index indexJar() throws MojoExecutionException {
        ArchiveScanner scanner = new ArchiveScanner(this.jar);
        scanner.setFilenameComparator(String::compareTo);
        if (this.useDefaultExcludes) {
            scanner.addDefaultExcludes();
        }
        if (this.includes != null) {
            scanner.setIncludes(this.includes.toArray(new String[0]));
        }
        if (this.excludes != null) {
            scanner.setExcludes(this.excludes.toArray(new String[0]));
        }
        scanner.scan();
        String[] filesInJar = scanner.getIncludedFiles();
        Indexer indexer = new Indexer();
        try (ZipFile zip = new ZipFile(this.jar);){
            for (String file : filesInJar) {
                if (!file.endsWith(".class")) continue;
                try (InputStream in = zip.getInputStream(zip.getEntry(file));){
                    ClassSummary info = indexer.indexWithSummary(in);
                    if (!this.isVerbose() || info == null) continue;
                    this.getLog().info((CharSequence)("Indexed " + info.name() + " (" + info.annotationsCount() + " annotations)"));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        return indexer.complete();
    }

    private Path createTempFile(String suffix) throws MojoExecutionException {
        try {
            return Files.createTempFile(this.jar.toPath().getParent(), this.jar.getName(), suffix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.flush();
    }

    private boolean isVerbose() {
        return this.verbose || this.getLog().isDebugEnabled();
    }
}

