/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.rule;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.keygen.KeyGenerator;
import io.shardingjdbc.core.routing.strategy.ShardingStrategy;
import io.shardingjdbc.core.rule.DataNode;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public final class TableRule {
    private final String logicTable;
    private final List<DataNode> actualDataNodes;
    private final ShardingStrategy databaseShardingStrategy;
    private final ShardingStrategy tableShardingStrategy;
    private final String generateKeyColumn;
    private final KeyGenerator keyGenerator;
    private final String logicIndex;

    public TableRule(String logicTable, List<String> actualDataNodes, Map<String, DataSource> dataSourceMap, ShardingStrategy databaseShardingStrategy, ShardingStrategy tableShardingStrategy, String generateKeyColumn, KeyGenerator keyGenerator, String logicIndex) {
        this.logicTable = logicTable.toLowerCase();
        this.actualDataNodes = null == actualDataNodes || actualDataNodes.isEmpty() ? this.generateDataNodes(logicTable, dataSourceMap) : this.generateDataNodes(actualDataNodes, dataSourceMap);
        this.databaseShardingStrategy = databaseShardingStrategy;
        this.tableShardingStrategy = tableShardingStrategy;
        this.generateKeyColumn = generateKeyColumn;
        this.keyGenerator = keyGenerator;
        this.logicIndex = null == logicIndex ? null : logicIndex.toLowerCase();
    }

    private List<DataNode> generateDataNodes(String logicTable, Map<String, DataSource> dataSourceMap) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : dataSourceMap.keySet()) {
            result.add(new DataNode(each, logicTable));
        }
        return result;
    }

    private List<DataNode> generateDataNodes(List<String> actualDataNodes, Map<String, DataSource> dataSourceMap) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : actualDataNodes) {
            DataNode dataNode = new DataNode(each);
            Preconditions.checkArgument((boolean)dataSourceMap.containsKey(dataNode.getDataSourceName()), (Object)String.format("Cannot find data source in sharding rule, invalid actual data node is: '%s'", each));
            result.add(dataNode);
        }
        return result;
    }

    public Collection<String> getActualDatasourceNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.actualDataNodes.size());
        for (DataNode each : this.actualDataNodes) {
            result.add(each.getDataSourceName());
        }
        return result;
    }

    public Collection<String> getActualTableNames(String targetDataSource) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.actualDataNodes.size());
        for (DataNode each : this.actualDataNodes) {
            if (!targetDataSource.equals(each.getDataSourceName())) continue;
            result.add(each.getTableName());
        }
        return result;
    }

    int findActualTableIndex(String dataSourceName, String actualTableName) {
        int result = 0;
        for (DataNode each : this.actualDataNodes) {
            if (each.getDataSourceName().equalsIgnoreCase(dataSourceName) && each.getTableName().equalsIgnoreCase(actualTableName)) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    public String getLogicTable() {
        return this.logicTable;
    }

    public List<DataNode> getActualDataNodes() {
        return this.actualDataNodes;
    }

    public ShardingStrategy getDatabaseShardingStrategy() {
        return this.databaseShardingStrategy;
    }

    public ShardingStrategy getTableShardingStrategy() {
        return this.tableShardingStrategy;
    }

    public String getGenerateKeyColumn() {
        return this.generateKeyColumn;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public String getLogicIndex() {
        return this.logicIndex;
    }

    public String toString() {
        return "TableRule(logicTable=" + this.getLogicTable() + ", actualDataNodes=" + this.getActualDataNodes() + ", databaseShardingStrategy=" + this.getDatabaseShardingStrategy() + ", tableShardingStrategy=" + this.getTableShardingStrategy() + ", generateKeyColumn=" + this.getGenerateKeyColumn() + ", keyGenerator=" + this.getKeyGenerator() + ", logicIndex=" + this.getLogicIndex() + ")";
    }
}

