/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.dialect.oracle.clause;

import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.lexer.dialect.oracle.OracleKeyword;
import io.shardingjdbc.core.parsing.lexer.token.DefaultKeyword;
import io.shardingjdbc.core.parsing.lexer.token.Symbol;
import io.shardingjdbc.core.parsing.parser.clause.SQLClauseParser;
import io.shardingjdbc.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingjdbc.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingjdbc.core.parsing.parser.sql.dql.select.SelectStatement;

public final class OracleForClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public OracleForClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(SelectStatement selectStatement) {
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.FOR)) {
            return;
        }
        this.lexerEngine.accept(DefaultKeyword.UPDATE);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.OF)) {
            do {
                this.basicExpressionParser.parse(selectStatement);
            } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        }
        if (this.lexerEngine.equalAny(OracleKeyword.NOWAIT, OracleKeyword.WAIT)) {
            this.lexerEngine.nextToken();
        } else if (this.lexerEngine.skipIfEqual(OracleKeyword.SKIP)) {
            this.lexerEngine.accept(OracleKeyword.LOCKED);
        }
    }
}

