/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.parsing.parser.dialect;

import io.shardingjdbc.core.parsing.lexer.LexerEngine;
import io.shardingjdbc.core.parsing.parser.clause.expression.AliasExpressionParser;
import io.shardingjdbc.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingjdbc.core.parsing.parser.dialect.mysql.clause.expression.MySQLAliasExpressionParser;
import io.shardingjdbc.core.parsing.parser.dialect.oracle.clause.expression.OracleAliasExpressionParser;
import io.shardingjdbc.core.parsing.parser.dialect.postgresql.clause.expression.PostgreSQLAliasExpressionParser;
import io.shardingjdbc.core.parsing.parser.dialect.sqlserver.clause.expression.SQLServerAliasExpressionParser;

public final class ExpressionParserFactory {
    public static AliasExpressionParser createAliasExpressionParser(LexerEngine lexerEngine) {
        switch (lexerEngine.getDatabaseType()) {
            case MySQL: {
                return new MySQLAliasExpressionParser(lexerEngine);
            }
            case Oracle: {
                return new OracleAliasExpressionParser(lexerEngine);
            }
            case SQLServer: {
                return new SQLServerAliasExpressionParser(lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLAliasExpressionParser(lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database type: %s", new Object[]{lexerEngine.getDatabaseType()}));
    }

    public static BasicExpressionParser createBasicExpressionParser(LexerEngine lexerEngine) {
        return new BasicExpressionParser(lexerEngine);
    }

    private ExpressionParserFactory() {
    }
}

