/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.util;

public class StringFormatUtils {
    private static final char MINUS = '-';
    private static final char UNDERLINE = '_';
    public static final char DOT = '.';

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        return StringFormatUtils.formatCamel(param, '_');
    }

    public static String minusToCamel(String param) {
        return StringFormatUtils.formatCamel(param, '-');
    }

    public static String dotToCamel(String param) {
        return StringFormatUtils.formatCamel(param, '.');
    }

    private static String formatCamel(String param, char sign) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (c == sign) {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

