/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.zk;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.StringUtils;
import io.seata.config.AbstractConfiguration;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationChangeType;
import io.seata.config.ConfigurationFactory;
import io.seata.config.zk.DefaultZkSerializer;
import java.lang.reflect.Constructor;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperConfiguration
extends AbstractConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfiguration.class);
    private static final String CONFIG_TYPE = "zk";
    private static final String ZK_PATH_SPLIT_CHAR = "/";
    private static final String ROOT_PATH = "/seata";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String SESSION_TIMEOUT_KEY = "sessionTimeout";
    private static final String CONNECT_TIMEOUT_KEY = "connectTimeout";
    private static final String AUTH_USERNAME = "username";
    private static final String AUTH_PASSWORD = "password";
    private static final String SERIALIZER_KEY = "serializer";
    private static final int THREAD_POOL_NUM = 1;
    private static final int DEFAULT_SESSION_TIMEOUT = 6000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    private static final String FILE_CONFIG_KEY_PREFIX = "config.zk.";
    private static final ExecutorService CONFIG_EXECUTOR = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("ZKConfigThread", 1));
    private static volatile ZkClient zkClient;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private ConcurrentMap<String, ConcurrentMap<ConfigurationChangeListener, ZKListener>> configListenersMap = new ConcurrentHashMap<String, ConcurrentMap<ConfigurationChangeListener, ZKListener>>(8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ZookeeperConfiguration() {
        if (zkClient != null) return;
        Class<ZookeeperConfiguration> clazz = ZookeeperConfiguration.class;
        synchronized (ZookeeperConfiguration.class) {
            if (zkClient == null) {
                ZkSerializer zkSerializer = this.getZkSerializer();
                String serverAddr = FILE_CONFIG.getConfig("config.zk.serverAddr");
                int sessionTimeout = FILE_CONFIG.getInt("config.zk.sessionTimeout", 6000);
                int connectTimeout = FILE_CONFIG.getInt("config.zk.connectTimeout", 2000);
                zkClient = new ZkClient(serverAddr, sessionTimeout, connectTimeout, zkSerializer);
                String username = FILE_CONFIG.getConfig("config.zk.username");
                String password = FILE_CONFIG.getConfig("config.zk.password");
                if (!StringUtils.isBlank((String)username) && !StringUtils.isBlank((String)password)) {
                    StringBuilder auth = new StringBuilder(username).append(":").append(password);
                    zkClient.addAuthInfo("digest", auth.toString().getBytes());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (zkClient.exists(ROOT_PATH)) return;
            zkClient.createPersistent(ROOT_PATH, true);
            return;
        }
    }

    public String getTypeName() {
        return CONFIG_TYPE;
    }

    public String getLatestConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = this.getConfigFromSysPro(dataId);
        if (value != null) {
            return value;
        }
        FutureTask<String> future = new FutureTask<String>(() -> {
            String path = "/seata/" + dataId;
            String value1 = (String)zkClient.readData(path);
            return StringUtils.isNullOrEmpty((String)value1) ? defaultValue : value1;
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.error("getConfig {} error or timeout, return defaultValue {}, exception:{} ", new Object[]{dataId, defaultValue, e.getMessage()});
            return defaultValue;
        }
    }

    public boolean putConfig(String dataId, String content, long timeoutMills) {
        FutureTask<Boolean> future = new FutureTask<Boolean>(() -> {
            String path = "/seata/" + dataId;
            if (!zkClient.exists(path)) {
                zkClient.create(path, (Object)content, CreateMode.PERSISTENT);
            } else {
                zkClient.writeData(path, (Object)content);
            }
            return true;
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.error("putConfig {}, value: {} is error or timeout, exception: {}", new Object[]{dataId, content, e.getMessage()});
            return false;
        }
    }

    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    public boolean removeConfig(String dataId, long timeoutMills) {
        FutureTask<Boolean> future = new FutureTask<Boolean>(() -> {
            String path = "/seata/" + dataId;
            return zkClient.delete(path);
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.error("removeConfig {} is error or timeout, exception:{}", (Object)dataId, (Object)e.getMessage());
            return false;
        }
    }

    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (dataId == null || listener == null) {
            return;
        }
        String path = "/seata/" + dataId;
        if (zkClient.exists(path)) {
            this.configListenersMap.putIfAbsent(dataId, new ConcurrentHashMap());
            ZKListener zkListener = new ZKListener(path, listener);
            ((ConcurrentMap)this.configListenersMap.get(dataId)).put(listener, zkListener);
            zkClient.subscribeDataChanges(path, (IZkDataListener)zkListener);
        }
    }

    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        Set<ConfigurationChangeListener> configChangeListeners = this.getConfigListeners(dataId);
        if (configChangeListeners == null || listener == null) {
            return;
        }
        String path = "/seata/" + dataId;
        if (zkClient.exists(path)) {
            for (ConfigurationChangeListener entry : configChangeListeners) {
                if (!listener.equals(entry)) continue;
                ZKListener zkListener = null;
                if (this.configListenersMap.containsKey(dataId)) {
                    zkListener = (ZKListener)((ConcurrentMap)this.configListenersMap.get(dataId)).get(listener);
                    ((ConcurrentMap)this.configListenersMap.get(dataId)).remove(entry);
                }
                if (zkListener == null) break;
                zkClient.unsubscribeDataChanges(path, zkListener);
                break;
            }
        }
    }

    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        if (this.configListenersMap.containsKey(dataId)) {
            return ((ConcurrentMap)this.configListenersMap.get(dataId)).keySet();
        }
        return null;
    }

    private ZkSerializer getZkSerializer() {
        DefaultZkSerializer zkSerializer = null;
        String serializer = FILE_CONFIG.getConfig("config.zk.serializer");
        if (StringUtils.isNotBlank((String)serializer)) {
            try {
                Class<?> clazz = Class.forName(serializer);
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                zkSerializer = (ZkSerializer)constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException cfe) {
                LOGGER.warn("No zk serializer class found, serializer:{}", (Object)serializer, (Object)cfe);
            }
            catch (Throwable cause) {
                LOGGER.warn("found zk serializer encountered an unknown exception", cause);
            }
        }
        if (zkSerializer == null) {
            zkSerializer = new DefaultZkSerializer();
            LOGGER.info("Use default zk serializer: io.seata.config.zk.DefaultZkSerializer.");
        }
        return zkSerializer;
    }

    public static class ZKListener
    implements IZkDataListener {
        private String path;
        private ConfigurationChangeListener listener;

        public ZKListener(String path, ConfigurationChangeListener listener) {
            this.path = path;
            this.listener = listener;
        }

        public void handleDataChange(String s, Object o) {
            ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(s).setNewValue(o.toString()).setChangeType(ConfigurationChangeType.MODIFY);
            this.listener.onProcessEvent(event);
        }

        public void handleDataDeleted(String s) {
            ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(s).setChangeType(ConfigurationChangeType.DELETE);
            this.listener.onProcessEvent(event);
        }
    }
}

