/*
 * Decompiled with CFR 0.152.
 */
package io.seata.codec.seata.protocol.transaction;

import io.seata.codec.seata.protocol.transaction.AbstractTransactionRequestToTCCodec;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.protocol.transaction.BranchReportRequest;
import java.nio.ByteBuffer;

public class BranchReportRequestCodec
extends AbstractTransactionRequestToTCCodec {
    @Override
    public Class<?> getMessageClassType() {
        return BranchReportRequest.class;
    }

    @Override
    public <T> void encode(T t, ByteBuffer out) {
        byte[] bs;
        BranchReportRequest branchReportRequest = (BranchReportRequest)t;
        String xid = branchReportRequest.getXid();
        long branchId = branchReportRequest.getBranchId();
        BranchStatus status = branchReportRequest.getStatus();
        String resourceId = branchReportRequest.getResourceId();
        String applicationData = branchReportRequest.getApplicationData();
        BranchType branchType = branchReportRequest.getBranchType();
        byte[] applicationDataBytes = null;
        if (applicationData != null) {
            applicationDataBytes = applicationData.getBytes(UTF8);
        }
        if (xid != null) {
            bs = xid.getBytes(UTF8);
            out.putShort((short)bs.length);
            if (bs.length > 0) {
                out.put(bs);
            }
        } else {
            out.putShort((short)0);
        }
        out.putLong(branchId);
        out.put((byte)status.getCode());
        if (resourceId != null) {
            bs = resourceId.getBytes(UTF8);
            out.putShort((short)bs.length);
            if (bs.length > 0) {
                out.put(bs);
            }
        } else {
            out.putShort((short)0);
        }
        if (applicationData != null) {
            out.putInt(applicationDataBytes.length);
            if (applicationDataBytes.length > 0) {
                out.put(applicationDataBytes);
            }
        } else {
            out.putInt(0);
        }
        out.put((byte)branchType.ordinal());
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        int iLen;
        BranchReportRequest branchReportRequest = (BranchReportRequest)t;
        short xidLen = in.getShort();
        if (xidLen > 0) {
            byte[] bs = new byte[xidLen];
            in.get(bs);
            branchReportRequest.setXid(new String(bs, UTF8));
        }
        branchReportRequest.setBranchId(in.getLong());
        branchReportRequest.setStatus(BranchStatus.get((byte)in.get()));
        short len = in.getShort();
        if (len > 0) {
            byte[] bs = new byte[len];
            in.get(bs);
            branchReportRequest.setResourceId(new String(bs, UTF8));
        }
        if ((iLen = in.getInt()) > 0) {
            byte[] bs = new byte[iLen];
            in.get(bs);
            branchReportRequest.setApplicationData(new String(bs, UTF8));
        }
        branchReportRequest.setBranchType(BranchType.get((byte)in.get()));
    }
}

