/*
 * Decompiled with CFR 0.152.
 */
package io.seata.codec.seata.protocol;

import io.seata.codec.seata.protocol.AbstractIdentifyRequestCodec;
import io.seata.core.protocol.RegisterRMRequest;
import java.nio.ByteBuffer;

public class RegisterRMRequestCodec
extends AbstractIdentifyRequestCodec {
    @Override
    public Class<?> getMessageClassType() {
        return RegisterRMRequest.class;
    }

    @Override
    protected <T> void doEncode(T t, ByteBuffer out) {
        super.doEncode(t, out);
        RegisterRMRequest registerRMRequest = (RegisterRMRequest)t;
        String resourceIds = registerRMRequest.getResourceIds();
        if (resourceIds != null) {
            byte[] bs = resourceIds.getBytes(UTF8);
            out.putInt(bs.length);
            if (bs.length > 0) {
                out.put(bs);
            }
        } else {
            out.putInt(0);
        }
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        RegisterRMRequest registerRMRequest = (RegisterRMRequest)t;
        if (in.remaining() < 2) {
            return;
        }
        short len = in.getShort();
        if (len > 0) {
            if (in.remaining() < len) {
                return;
            }
        } else {
            return;
        }
        byte[] bs = new byte[len];
        in.get(bs);
        registerRMRequest.setVersion(new String(bs, UTF8));
        if (in.remaining() < 2) {
            return;
        }
        len = in.getShort();
        if (len > 0) {
            if (in.remaining() < len) {
                return;
            }
            bs = new byte[len];
            in.get(bs);
            registerRMRequest.setApplicationId(new String(bs, UTF8));
        }
        if (in.remaining() < 2) {
            return;
        }
        len = in.getShort();
        if (in.remaining() < len) {
            return;
        }
        bs = new byte[len];
        in.get(bs);
        registerRMRequest.setTransactionServiceGroup(new String(bs, UTF8));
        if (in.remaining() < 2) {
            return;
        }
        len = in.getShort();
        if (len > 0) {
            if (in.remaining() < len) {
                return;
            }
            bs = new byte[len];
            in.get(bs);
            registerRMRequest.setExtraData(new String(bs, UTF8));
        }
        if (in.remaining() < 4) {
            return;
        }
        int iLen = in.getInt();
        if (iLen > 0) {
            if (in.remaining() < iLen) {
                return;
            }
            bs = new byte[iLen];
            in.get(bs);
            registerRMRequest.setResourceIds(new String(bs, UTF8));
        }
    }
}

