/*
 * Decompiled with CFR 0.152.
 */
package io.seata.codec.seata;

import io.seata.codec.seata.MessageCodecFactory;
import io.seata.codec.seata.MessageSeataCodec;
import io.seata.common.loader.LoadLevel;
import io.seata.core.codec.Codec;
import io.seata.core.protocol.AbstractMessage;
import java.nio.ByteBuffer;

@LoadLevel(name="SEATA")
public class SeataCodec
implements Codec {
    public <T> byte[] encode(T t) {
        if (t == null || !(t instanceof AbstractMessage)) {
            throw new IllegalArgumentException("AbstractMessage isn't available.");
        }
        AbstractMessage abstractMessage = (AbstractMessage)t;
        short typecode = abstractMessage.getTypeCode();
        MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typecode);
        ByteBuffer out = MessageCodecFactory.getByteBuffer(abstractMessage);
        messageCodec.encode(t, out);
        out.flip();
        byte[] body = new byte[out.limit()];
        out.get(body);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + body.length);
        byteBuffer.putShort(typecode);
        byteBuffer.put(body);
        byteBuffer.flip();
        byte[] content = new byte[byteBuffer.limit()];
        byteBuffer.get(content);
        return content;
    }

    public <T> T decode(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("Nothing to decode.");
        }
        if (bytes.length < 2) {
            throw new IllegalArgumentException("The byte[] isn't available for decode.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        short typecode = byteBuffer.getShort();
        byte[] body = new byte[byteBuffer.remaining()];
        byteBuffer.get(body);
        ByteBuffer in = ByteBuffer.wrap(body);
        AbstractMessage abstractMessage = MessageCodecFactory.getMessage(typecode);
        MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typecode);
        messageCodec.decode(abstractMessage, in);
        return (T)abstractMessage;
    }
}

