/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.rsocket.internal.BaseDuplexConnection;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;

public final class WebsocketDuplexConnection
extends BaseDuplexConnection {
    private final Connection connection;

    public WebsocketDuplexConnection(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "connection must not be null");
        connection.channel().closeFuture().addListener(future -> {
            if (!this.isDisposed()) {
                this.dispose();
            }
        });
    }

    public ByteBufAllocator alloc() {
        return this.connection.channel().alloc();
    }

    protected void doOnClose() {
        if (!this.connection.isDisposed()) {
            this.connection.dispose();
        }
    }

    public Flux<ByteBuf> receive() {
        return this.connection.inbound().receive().map(ByteBuf::retain);
    }

    public Mono<Void> send(Publisher<ByteBuf> frames) {
        if (frames instanceof Mono) {
            return this.connection.outbound().sendObject((Publisher)((Mono)frames).map(BinaryWebSocketFrame::new)).then();
        }
        return this.connection.outbound().sendObject((Publisher)Flux.from(frames).map(BinaryWebSocketFrame::new)).then();
    }
}

