/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.rsocket.core.Invalidatable;
import io.rsocket.core.ResolvingOperator;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class ReconnectMono<T>
extends Mono<T>
implements Invalidatable,
Disposable,
Scannable {
    final Mono<T> source;
    final BiConsumer<? super T, Invalidatable> onValueReceived;
    final Consumer<? super T> onValueExpired;
    final ResolvingInner<T> resolvingInner;

    ReconnectMono(Mono<T> source, Consumer<? super T> onValueExpired, BiConsumer<? super T, Invalidatable> onValueReceived) {
        this.source = source;
        this.onValueExpired = onValueExpired;
        this.onValueReceived = onValueReceived;
        this.resolvingInner = new ResolvingInner(this);
    }

    public Mono<T> getSource() {
        return this.source;
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return Integer.MAX_VALUE;
        }
        boolean isDisposed = this.isDisposed();
        if (key == Scannable.Attr.TERMINATED) {
            return isDisposed;
        }
        if (key == Scannable.Attr.ERROR) {
            return this.resolvingInner.t;
        }
        return null;
    }

    @Override
    public void invalidate() {
        this.resolvingInner.invalidate();
    }

    public void dispose() {
        this.resolvingInner.terminate(new CancellationException("ReconnectMono has already been disposed"));
    }

    public boolean isDisposed() {
        return this.resolvingInner.isDisposed();
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        ResolvingOperator.MonoDeferredResolutionOperator<? super T> inner = new ResolvingOperator.MonoDeferredResolutionOperator<T>(this.resolvingInner, actual);
        actual.onSubscribe(inner);
        this.resolvingInner.observe(inner);
    }

    @Nullable
    public T block() {
        return this.block(null);
    }

    @Nullable
    public T block(@Nullable Duration timeout) {
        return this.resolvingInner.block(timeout);
    }

    static final class ResolvingInner<T>
    extends ResolvingOperator<T>
    implements Scannable {
        final ReconnectMono<T> parent;
        final ReconnectMainSubscriber<? super T> mainSubscriber;

        ResolvingInner(ReconnectMono<T> parent) {
            this.parent = parent;
            this.mainSubscriber = new ReconnectMainSubscriber(this);
        }

        @Override
        protected void doOnValueExpired(T value) {
            this.parent.onValueExpired.accept(value);
        }

        @Override
        protected void doOnValueResolved(T value) {
            this.parent.onValueReceived.accept(value, this.parent);
        }

        @Override
        protected void doOnDispose() {
            this.mainSubscriber.dispose();
        }

        @Override
        protected void doSubscribe() {
            this.parent.source.subscribe(this.mainSubscriber);
        }

        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            return null;
        }
    }

    static final class ReconnectMainSubscriber<T>
    implements CoreSubscriber<T> {
        final ResolvingInner<T> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<ReconnectMainSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(ReconnectMainSubscriber.class, Subscription.class, "s");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ReconnectMainSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(ReconnectMainSubscriber.class, "wip");
        T value;

        ReconnectMainSubscriber(ResolvingInner<T> parent) {
            this.parent = parent;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, (Object)this, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onComplete() {
            Subscription s = this.s;
            T value = this.value;
            if (s == Operators.cancelledSubscription() || !S.compareAndSet(this, s, null)) {
                this.doFinally();
                return;
            }
            ResolvingInner<T> p = this.parent;
            if (value == null) {
                p.terminate(new IllegalStateException("Source completed empty"));
            } else {
                p.complete(value);
            }
        }

        public void onError(Throwable t) {
            Subscription s = this.s;
            if (s == Operators.cancelledSubscription() || S.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
                this.doFinally();
                Operators.onErrorDropped((Throwable)t, (Context)Context.empty());
                return;
            }
            this.doFinally();
            this.parent.terminate(t);
        }

        public void onNext(T value) {
            if (this.s == Operators.cancelledSubscription()) {
                this.parent.doOnValueExpired(value);
                return;
            }
            this.value = value;
            this.doFinally();
        }

        void dispose() {
            if (Operators.terminate(S, (Object)this)) {
                this.doFinally();
            }
        }

        final void doFinally() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int m = 1;
            do {
                T value;
                if ((value = this.value) == null || this.s != Operators.cancelledSubscription()) continue;
                this.value = null;
                this.parent.doOnValueExpired(value);
                return;
            } while ((m = WIP.addAndGet(this, -m)) != 0);
        }
    }
}

