/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.it.verifier;

import io.quarkus.maven.it.MojoTestBase;
import io.quarkus.maven.it.verifier.MavenProcessInvocationResult;
import io.quarkus.maven.it.verifier.MavenProcessInvoker;
import io.quarkus.test.devmode.util.DevModeTestUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.apache.maven.shared.invoker.PrintStreamLogger;

public class RunningInvoker
extends MavenProcessInvoker {
    private final boolean parallel;
    private final boolean debug;
    private MavenProcessInvocationResult result;
    private final File log;
    private final PrintStreamHandler outStreamHandler;
    private final PrintStreamHandler errStreamHandler;

    public RunningInvoker(File basedir, boolean debug) {
        this(basedir, debug, false);
    }

    public RunningInvoker(File basedir, boolean debug, boolean parallel) {
        PrintStream errStream;
        PrintStream outStream;
        this.parallel = parallel;
        this.debug = debug;
        this.setWorkingDirectory(basedir);
        String repo = System.getProperty("maven.repo.local");
        if (repo == null) {
            repo = new File(System.getProperty("user.home"), ".m2/repository").getAbsolutePath();
        }
        this.setLocalRepositoryDirectory(new File(repo));
        this.log = new File(basedir, "build-" + basedir.getName() + ".log");
        try {
            outStream = RunningInvoker.createTeePrintStream(System.out, Files.newOutputStream(this.log.toPath(), new OpenOption[0]));
        }
        catch (IOException ioe) {
            outStream = System.out;
        }
        this.outStreamHandler = new PrintStreamHandler(outStream, true);
        this.setOutputHandler((InvocationOutputHandler)this.outStreamHandler);
        try {
            errStream = RunningInvoker.createTeePrintStream(System.err, Files.newOutputStream(this.log.toPath(), new OpenOption[0]));
        }
        catch (IOException ioe) {
            errStream = System.err;
        }
        this.errStreamHandler = new PrintStreamHandler(errStream, true);
        this.setErrorHandler((InvocationOutputHandler)this.errStreamHandler);
        this.setLogger((InvokerLogger)new PrintStreamLogger(outStream, debug ? 4 : 3));
    }

    private static PrintStream createTeePrintStream(OutputStream one, OutputStream two) {
        PrintStream stream;
        TeeOutputStream tee = new TeeOutputStream(one, two);
        try {
            stream = new PrintStream((OutputStream)tee, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            stream = new PrintStream((OutputStream)tee, true);
        }
        return stream;
    }

    public void stop() {
        if (this.result == null) {
            return;
        }
        DevModeTestUtils.killDescendingProcesses();
        this.result.destroy();
    }

    public MavenProcessInvocationResult execute(List<String> goals, Map<String, String> envVars) throws MavenInvocationException {
        return this.execute(goals, envVars, new Properties());
    }

    public MavenProcessInvocationResult execute(List<String> goals, Map<String, String> envVars, Properties properties) throws MavenInvocationException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(goals);
        request.setDebug(this.debug);
        if (this.parallel) {
            request.setThreads("1C");
        }
        request.setLocalRepositoryDirectory(this.getLocalRepositoryDirectory());
        request.setBaseDirectory(this.getWorkingDirectory());
        request.setPomFile(new File(this.getWorkingDirectory(), "pom.xml"));
        request.setProperties(properties);
        if (System.getProperty("mavenOpts") != null) {
            request.setMavenOpts(System.getProperty("mavenOpts"));
        } else {
            request.setMavenOpts("-Xmx128m");
        }
        request.setShellEnvironmentInherited(true);
        envVars.forEach((arg_0, arg_1) -> ((DefaultInvocationRequest)request).addShellEnvironment(arg_0, arg_1));
        request.setOutputHandler((InvocationOutputHandler)this.outStreamHandler);
        request.setErrorHandler((InvocationOutputHandler)this.errStreamHandler);
        this.result = (MavenProcessInvocationResult)this.execute((InvocationRequest)request);
        return this.result;
    }

    @Override
    public InvocationResult execute(InvocationRequest request) throws MavenInvocationException {
        MojoTestBase.passUserSettings(request);
        return super.execute(request);
    }

    public String log() throws IOException {
        if (this.log == null) {
            return null;
        }
        return FileUtils.readFileToString((File)this.log, (String)"UTF-8");
    }

    public MavenProcessInvocationResult getResult() {
        return this.result;
    }
}

