/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.it.continuoustesting;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;

public class ContinuousTestingMavenTestUtils {
    static final URL DEFAULT;
    long runtToWaitFor = 1L;
    ObjectMapper objectMapper = new ObjectMapper();
    final URL url;

    public ContinuousTestingMavenTestUtils() {
        this(DEFAULT);
    }

    public ContinuousTestingMavenTestUtils(URL url) {
        this.url = url;
    }

    public TestStatus waitForNextCompletion() {
        TestStatus testStatus;
        block10: {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            try {
                Awaitility.waitAtMost((long)1L, (TimeUnit)TimeUnit.MINUTES).pollInterval(50L, TimeUnit.MILLISECONDS).until((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        boolean runComplete;
                        TestStatus ts = (TestStatus)ContinuousTestingMavenTestUtils.this.objectMapper.readValue(ContinuousTestingMavenTestUtils.this.url, TestStatus.class);
                        if (ts.getLastRun() > ContinuousTestingMavenTestUtils.this.runtToWaitFor) {
                            throw new RuntimeException("Waiting for run " + ContinuousTestingMavenTestUtils.this.runtToWaitFor + " but run " + ts.getLastRun() + " has already occurred");
                        }
                        boolean bl = runComplete = ts.getLastRun() == ContinuousTestingMavenTestUtils.this.runtToWaitFor;
                        if (runComplete && ts.getRunning() > 0L) {
                            ContinuousTestingMavenTestUtils.this.runtToWaitFor = ts.getRunning();
                            return false;
                        }
                        if (runComplete) {
                            ++ContinuousTestingMavenTestUtils.this.runtToWaitFor;
                        }
                        return runComplete;
                    }
                });
                testStatus = (TestStatus)this.objectMapper.readValue(this.url, TestStatus.class);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    TestStatus ts = null;
                    try {
                        ts = (TestStatus)this.objectMapper.readValue(this.url, TestStatus.class);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    throw new ConditionTimeoutException("Failed to wait for test run" + this.runtToWaitFor + " " + ts);
                }
            }
            client.close();
        }
        return testStatus;
    }

    public static String appProperties(String ... props) {
        return "quarkus.test.continuous-testing=enabled\nquarkus.test.display-test-output=true\nquarkus.test.basic-console=true\nquarkus.test.disable-console-input=true\n" + String.join((CharSequence)"\n", Arrays.asList(props));
    }

    static {
        try {
            DEFAULT = new URL("http://localhost:8080/q/dev/io.quarkus.quarkus-vertx-http/tests/status");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TestStatus {
        private long lastRun;
        private long running;
        private long testsRun = -1L;
        private long testsPassed = -1L;
        private long testsFailed = -1L;
        private long testsSkipped = -1L;
        private long totalTestsPassed = -1L;
        private long totalTestsFailed = -1L;
        private long totalTestsSkipped = -1L;

        public TestStatus() {
        }

        public TestStatus(long lastRun, long running, long testsRun, long testsPassed, long testsFailed, long testsSkipped, long totalTestsPassed, long totalTestsFailed, long totalTestsSkipped) {
            this.lastRun = lastRun;
            this.running = running;
            this.testsRun = testsRun;
            this.testsPassed = testsPassed;
            this.testsFailed = testsFailed;
            this.testsSkipped = testsSkipped;
            this.totalTestsPassed = totalTestsPassed;
            this.totalTestsFailed = totalTestsFailed;
            this.totalTestsSkipped = totalTestsSkipped;
        }

        public long getLastRun() {
            return this.lastRun;
        }

        public TestStatus setLastRun(long lastRun) {
            this.lastRun = lastRun;
            return this;
        }

        public long getRunning() {
            return this.running;
        }

        public TestStatus setRunning(long running) {
            this.running = running;
            return this;
        }

        public long getTestsRun() {
            return this.testsRun;
        }

        public TestStatus setTestsRun(long testsRun) {
            this.testsRun = testsRun;
            return this;
        }

        public long getTestsPassed() {
            return this.testsPassed;
        }

        public TestStatus setTestsPassed(long testsPassed) {
            this.testsPassed = testsPassed;
            return this;
        }

        public long getTestsFailed() {
            return this.testsFailed;
        }

        public TestStatus setTestsFailed(long testsFailed) {
            this.testsFailed = testsFailed;
            return this;
        }

        public long getTestsSkipped() {
            return this.testsSkipped;
        }

        public TestStatus setTestsSkipped(long testsSkipped) {
            this.testsSkipped = testsSkipped;
            return this;
        }

        public long getTotalTestsPassed() {
            return this.totalTestsPassed;
        }

        public TestStatus setTotalTestsPassed(long totalTestsPassed) {
            this.totalTestsPassed = totalTestsPassed;
            return this;
        }

        public long getTotalTestsFailed() {
            return this.totalTestsFailed;
        }

        public TestStatus setTotalTestsFailed(long totalTestsFailed) {
            this.totalTestsFailed = totalTestsFailed;
            return this;
        }

        public long getTotalTestsSkipped() {
            return this.totalTestsSkipped;
        }

        public TestStatus setTotalTestsSkipped(long totalTestsSkipped) {
            this.totalTestsSkipped = totalTestsSkipped;
            return this;
        }

        public String toString() {
            return "TestStatus{lastRun=" + this.lastRun + ", running=" + this.running + ", testsRun=" + this.testsRun + ", testsPassed=" + this.testsPassed + ", testsFailed=" + this.testsFailed + ", testsSkipped=" + this.testsSkipped + "}";
        }
    }
}

