/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.it;

import io.quarkus.maven.it.MojoTestBase;
import io.quarkus.maven.it.verifier.MavenProcessInvocationResult;
import io.quarkus.maven.it.verifier.RunningInvoker;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.test.devmode.util.DevModeTestUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;

public class RunAndCheckMojoTestBase
extends MojoTestBase {
    protected RunningInvoker running;
    protected File testDir;

    @AfterEach
    public void cleanup() {
        this.shutdownTheApp();
    }

    public void shutdownTheApp() {
        if (this.running != null) {
            this.running.stop();
        }
        DevModeTestUtils.awaitUntilServerDown();
    }

    protected LaunchMode getDefaultLaunchMode() {
        return LaunchMode.DEVELOPMENT;
    }

    protected void run(boolean performCompile, String ... options) throws FileNotFoundException, MavenInvocationException {
        this.run(performCompile, this.getDefaultLaunchMode(), options);
    }

    protected void run(boolean performCompile, LaunchMode mode, String ... options) throws FileNotFoundException, MavenInvocationException {
        Assertions.assertThat((File)this.testDir).isDirectory();
        this.running = new RunningInvoker(this.testDir, false);
        ArrayList<String> args = new ArrayList<String>(2 + options.length);
        if (performCompile) {
            args.add("compile");
        }
        args.add("quarkus:" + mode.getDefaultProfile());
        boolean hasDebugOptions = false;
        for (String option : options) {
            args.add(option);
            if (!option.trim().startsWith("-Ddebug=") && !option.trim().startsWith("-Dsuspend=")) continue;
            hasDebugOptions = true;
        }
        if (!hasDebugOptions) {
            args.add("-Ddebug=false");
        }
        args.add("-Djvm.args=-Xmx128m");
        this.running.execute(args, Map.of());
    }

    protected void runAndCheck(String ... options) throws FileNotFoundException, MavenInvocationException {
        this.runAndCheck(true, options);
    }

    protected void runAndCheck(LaunchMode mode, String ... options) throws FileNotFoundException, MavenInvocationException {
        this.runAndCheck(true, mode, options);
    }

    protected void runAndCheck(boolean performCompile, String ... options) throws MavenInvocationException, FileNotFoundException {
        this.runAndCheck(performCompile, this.getDefaultLaunchMode(), options);
    }

    protected void runAndCheck(boolean performCompile, LaunchMode mode, String ... options) throws FileNotFoundException, MavenInvocationException {
        this.run(performCompile, mode, options);
        String resp = DevModeTestUtils.getHttpResponse();
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)resp).containsIgnoringCase((CharSequence)"ready")).containsIgnoringCase((CharSequence)"application")).containsIgnoringCase((CharSequence)"org.acme")).containsIgnoringCase((CharSequence)"1.0-SNAPSHOT");
        String greeting = DevModeTestUtils.getHttpResponse((String)"/app/hello");
        Assertions.assertThat((String)greeting).containsIgnoringCase((CharSequence)"hello");
    }

    protected void runAndExpectError() throws MavenInvocationException {
        Assertions.assertThat((File)this.testDir).isDirectory();
        this.running = new RunningInvoker(this.testDir, false);
        Properties mvnRunProps = new Properties();
        mvnRunProps.setProperty("debug", "false");
        this.running.execute(Arrays.asList("compile", "quarkus:dev"), Map.of(), mvnRunProps);
        DevModeTestUtils.getHttpErrorResponse();
    }

    protected void install(File baseDir, boolean performClean) throws Exception {
        MavenProcessInvocationResult result = new RunningInvoker(baseDir, false).execute(performClean ? List.of("clean", "install") : List.of("install"), Map.of());
        Process process = result.getProcess();
        if (process == null) {
            if (result.getExecutionException() == null) {
                throw new IllegalStateException("Failed to build project");
            }
            throw result.getExecutionException();
        }
        process.waitFor();
    }

    public String getHttpErrorResponse() {
        return DevModeTestUtils.getHttpErrorResponse(this.getBrokenReason());
    }

    public String getHttpResponse() {
        return DevModeTestUtils.getHttpResponse(this.getBrokenReason());
    }

    protected Supplier<String> getBrokenReason() {
        return () -> null;
    }
}

