/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.it;

import io.quarkus.devtools.testing.RegistryClientTestHelper;
import io.quarkus.test.devmode.util.DevModeTestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.assertj.core.api.Assertions;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MojoTestBase {
    public Invoker initInvoker(File root) {
        DefaultInvoker invoker = new DefaultInvoker(){

            public InvocationResult execute(InvocationRequest request) throws MavenInvocationException {
                MojoTestBase.passUserSettings(request);
                MojoTestBase.this.getEnv().forEach((arg_0, arg_1) -> ((InvocationRequest)request).addShellEnvironment(arg_0, arg_1));
                MojoTestBase.enableDevToolsTestConfig(request);
                return super.execute(request);
            }
        };
        invoker.setWorkingDirectory(root);
        String repo = System.getProperty("maven.repo.local");
        if (repo == null) {
            repo = new File(System.getProperty("user.home"), ".m2/repository").getAbsolutePath();
        }
        invoker.setLocalRepositoryDirectory(new File(repo));
        return invoker;
    }

    public static void passUserSettings(InvocationRequest request) {
        File settingsFile;
        String mvnSettings = System.getProperty("maven.settings");
        if (mvnSettings != null && (settingsFile = new File(mvnSettings)).exists()) {
            request.setUserSettingsFile(settingsFile);
        }
    }

    public static File initEmptyProject(String name) {
        File tc = new File("target/test-classes/" + name);
        if (tc.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)tc);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot delete directory: " + tc, e);
            }
        }
        boolean mkdirs = tc.mkdirs();
        Logger.getLogger(MojoTestBase.class.getName()).log(Level.FINE, "test-classes created? %s", mkdirs);
        return tc;
    }

    public static File initProject(String name) {
        File in;
        File tc = new File("target/test-classes");
        if (!tc.isDirectory()) {
            boolean mkdirs = tc.mkdirs();
            Logger.getLogger(MojoTestBase.class.getName()).log(Level.FINE, "test-classes created? %s", mkdirs);
        }
        if (!(in = new File(tc, name)).isDirectory()) {
            throw new RuntimeException("Cannot find directory: " + in.getAbsolutePath());
        }
        return in;
    }

    public static File getTargetDir(String name) {
        return new File("target/test-classes/" + name);
    }

    public static File initProject(String name, String output) {
        File in;
        File tc = new File("target/test-classes");
        if (!tc.isDirectory()) {
            boolean mkdirs = tc.mkdirs();
            Logger.getLogger(MojoTestBase.class.getName()).log(Level.FINE, "test-classes created? %s", mkdirs);
        }
        if (!(in = new File(tc, name)).isDirectory()) {
            throw new RuntimeException("Cannot find directory: " + in.getAbsolutePath());
        }
        File out = new File(tc, output);
        if (out.isDirectory()) {
            FileUtils.deleteQuietly((File)out);
        }
        boolean mkdirs = out.mkdirs();
        Logger.getLogger(MojoTestBase.class.getName()).log(Level.FINE, out.getAbsolutePath() + " created? " + mkdirs);
        try {
            org.codehaus.plexus.util.FileUtils.copyDirectoryStructure((File)in, (File)out);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot copy project resources", e);
        }
        return out;
    }

    public static void filter(File input, Map<String, String> variables) throws IOException {
        DevModeTestUtils.filter((File)input, variables);
    }

    public Map<String, String> getEnv() {
        String opts = System.getProperty("mavenOpts");
        HashMap<String, String> env = new HashMap<String, String>();
        if (opts != null) {
            env.put("MAVEN_OPTS", opts);
        }
        return env;
    }

    public static void assertThatOutputWorksCorrectly(String logs) {
        Assertions.assertThat((boolean)logs.isEmpty()).isFalse();
        String infoLogLevel = "INFO";
        Assertions.assertThat((boolean)logs.contains(infoLogLevel)).isTrue();
        Predicate<String> datePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}\\s\\d{2}:\\d{2}:\\d{2},\\d{3}").asPredicate();
        Assertions.assertThat((boolean)datePattern.test(logs)).isTrue();
        Assertions.assertThat((boolean)logs.contains("cdi, resteasy, smallrye-context-propagation, vertx, websockets")).isTrue();
        Assertions.assertThat((boolean)logs.contains("JBoss Threads version")).isFalse();
    }

    public static Model loadPom(File directory) {
        Model model;
        File pom = new File(directory, "pom.xml");
        Assertions.assertThat((File)pom).isFile();
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(pom), StandardCharsets.UTF_8);
        try {
            model = new MavenXpp3Reader().read((Reader)isr);
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XmlPullParserException e) {
                throw new IllegalArgumentException("Cannot read the pom.xml file", e);
            }
        }
        isr.close();
        return model;
    }

    public static List<File> getFilesEndingWith(File dir, String suffix) {
        File[] files = dir.listFiles((d, name) -> name.endsWith(suffix));
        return files != null ? Arrays.asList(files) : Collections.emptyList();
    }

    public static void enableDevToolsTestConfig(InvocationRequest request) {
        Properties properties = request.getProperties();
        if (properties == null) {
            properties = new Properties();
            request.setProperties(properties);
        }
        MojoTestBase.enableDevToolsTestConfig(properties);
    }

    public static void enableDevToolsTestConfig(Properties properties) {
        RegistryClientTestHelper.enableRegistryClientTestConfig((Properties)properties);
    }

    public static void disableDevToolsTestConfig(Properties properties) {
        RegistryClientTestHelper.disableRegistryClientTestConfig((Properties)properties);
    }
}

