/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="validate-extension-catalog", threadSafe=true)
public class ValidateExtensionsJsonMojo
extends AbstractMojo {
    @Parameter(property="jsonGroupId", required=true)
    private String jsonGroupId;
    @Parameter(property="jsonArtifactId", required=true)
    private String jsonArtifactId;
    @Parameter(property="jsonVersion", required=true)
    private String jsonVersion;
    @Parameter(defaultValue="false", property="quarkus.validate-extensions-json.skip")
    private boolean skip;
    @Component
    private RepositorySystem repoSystem;
    @Component
    private RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter
    private Set<String> ignoredGroupIds = new HashSet<String>(0);

    public void execute() throws MojoExecutionException, MojoFailureException {
        ExtensionCatalog catalog;
        Path jsonPath;
        MavenArtifactResolver mvn;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping as required by the mojo configuration");
            return;
        }
        try {
            mvn = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRepositorySystemSession(this.repoSession)).setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).build();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to initialize maven artifact resolver", e);
        }
        DefaultArtifact artifact = new DefaultArtifact(this.jsonGroupId, this.jsonArtifactId, this.jsonVersion, "json", this.jsonVersion);
        try {
            jsonPath = mvn.resolve((Artifact)artifact).getArtifact().getFile().toPath();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve platform descriptor " + (Artifact)artifact, (Exception)((Object)e));
        }
        try {
            catalog = ExtensionCatalog.fromFile((Path)jsonPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to deserialize extension catalog " + jsonPath, (Exception)e);
        }
        ArtifactCoords bomCoords = catalog.getBom();
        DefaultArtifact bomArtifact = new DefaultArtifact(bomCoords.getGroupId(), bomCoords.getArtifactId(), bomCoords.getClassifier(), bomCoords.getType(), bomCoords.getVersion());
        Map<ArtifactKey, ArtifactCoords> bomExtensionArtifacts = this.collectBomExtensionArtifacts(mvn, bomArtifact);
        ArrayList<ArtifactCoords> missingFromBom = new ArrayList<ArtifactCoords>();
        for (Extension extension : catalog.getExtensions()) {
            Path rtJar;
            ArtifactKey deploymentKey;
            ArtifactCoords rtCoords = extension.getArtifact();
            if (bomExtensionArtifacts.remove(rtCoords.getKey()) == null) {
                missingFromBom.add(rtCoords);
            }
            if (bomExtensionArtifacts.remove(deploymentKey = ArtifactKey.of((String)rtCoords.getGroupId(), (String)(rtCoords.getArtifactId() + "-deployment"), (String)rtCoords.getClassifier(), (String)rtCoords.getType())) != null) continue;
            DefaultArtifact rtArtifact = new DefaultArtifact(rtCoords.getGroupId(), rtCoords.getArtifactId(), rtCoords.getClassifier(), rtCoords.getType(), rtCoords.getVersion());
            try {
                rtJar = mvn.resolve((Artifact)rtArtifact).getArtifact().getFile().toPath();
            }
            catch (BootstrapMavenException e) {
                throw new MojoExecutionException("Failed to resolve " + rtCoords, (Exception)((Object)e));
            }
            ArtifactCoords deploymentCoords = (ArtifactCoords)PathTree.ofDirectoryOrArchive((Path)rtJar).apply("META-INF/quarkus-extension.properties", arg_0 -> this.lambda$execute$0((Artifact)rtArtifact, arg_0));
            if (deploymentCoords == null) {
                throw new MojoExecutionException("Failed to determine the corresponding deployment artifact for " + rtCoords.toCompactCoords());
            }
            if (bomExtensionArtifacts.remove(deploymentCoords.getKey()) != null) continue;
            missingFromBom.add(deploymentCoords);
        }
        if (bomExtensionArtifacts.isEmpty() && missingFromBom.isEmpty()) {
            return;
        }
        if (!bomExtensionArtifacts.isEmpty()) {
            this.getLog().error((CharSequence)("Extensions from " + bomArtifact + " mising from " + (Artifact)artifact));
            for (Map.Entry entry : bomExtensionArtifacts.entrySet()) {
                this.getLog().error((CharSequence)("- " + ((ArtifactCoords)entry.getValue()).toCompactCoords()));
            }
        }
        if (!missingFromBom.isEmpty()) {
            this.getLog().error((CharSequence)("Extension artifacts from " + (Artifact)artifact + " missing from " + bomArtifact));
            for (ArtifactCoords artifactCoords : missingFromBom) {
                this.getLog().error((CharSequence)("- " + artifactCoords));
            }
        }
        throw new MojoExecutionException("Extensions referenced in " + bomArtifact + " and included in " + (Artifact)artifact + " do not match expectations. See the errors logged above.");
    }

    private Map<ArtifactKey, ArtifactCoords> collectBomExtensionArtifacts(MavenArtifactResolver mvn, DefaultArtifact platformBom) throws MojoExecutionException {
        List bomDeps;
        try {
            bomDeps = mvn.resolveDescriptor((Artifact)platformBom).getManagedDependencies();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve platform BOM " + platformBom, e);
        }
        HashMap<ArtifactKey, ArtifactCoords> bomExtensions = new HashMap<ArtifactKey, ArtifactCoords>(bomDeps.size());
        for (Dependency dep : bomDeps) {
            Artifact resolvedArtifact;
            Artifact artifact = dep.getArtifact();
            if (this.ignoredGroupIds.contains(artifact.getGroupId()) || !artifact.getExtension().equals("jar") || "javadoc".equals(artifact.getClassifier()) || "tests".equals(artifact.getClassifier()) || "sources".equals(artifact.getClassifier())) continue;
            try {
                resolvedArtifact = mvn.resolve(artifact).getArtifact();
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Failed to resolve " + artifact + " present in the dependencyManagement section of " + platformBom));
                continue;
            }
            this.analyzeArtifact(resolvedArtifact, bomExtensions);
        }
        return bomExtensions;
    }

    private void analyzeArtifact(Artifact artifact, Map<ArtifactKey, ArtifactCoords> extensions) throws MojoExecutionException {
        Path path = artifact.getFile().toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            throw new MojoExecutionException("Failed to locate " + artifact + " at " + path);
        }
        PathTree content = PathTree.ofDirectoryOrArchive((Path)path);
        content.accept("META-INF", visit -> {
            Path descrJson;
            Path descrYaml;
            if (visit == null) {
                return;
            }
            Path metaInf = visit.getPath();
            Path descrProps = metaInf.resolve("quarkus-extension.properties");
            if (ValidateExtensionsJsonMojo.ensureExtensionMetadata(artifact, descrProps, descrYaml = metaInf.resolve("quarkus-extension.yaml"), descrJson = metaInf.resolve("quarkus-extension.json"))) {
                ArtifactCoords deployment = this.readDeploymentCoords(descrProps, artifact);
                ArtifactKey key = ArtifactKey.of((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getClassifier(), (String)artifact.getExtension());
                extensions.put(key, ArtifactCoords.of((String)key.getGroupId(), (String)key.getArtifactId(), (String)key.getClassifier(), (String)key.getType(), (String)artifact.getVersion()));
                extensions.put(deployment.getKey(), deployment);
            }
        });
    }

    private ArtifactCoords readDeploymentCoords(Path descrProps, Artifact artifact) {
        Properties props = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(descrProps);){
            props.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + descrProps + " from " + artifact);
        }
        String s = props.getProperty("deployment-artifact");
        if (s == null) {
            throw new RuntimeException(artifact + " is missing deployment-artifact property in " + descrProps);
        }
        ArtifactCoords deployment = ArtifactCoords.fromString((String)s);
        return deployment;
    }

    private static boolean ensureExtensionMetadata(Artifact a, Path properties, Path yaml, Path json) {
        boolean metadataExists;
        boolean propsExist = Files.exists(properties, new LinkOption[0]);
        boolean bl = metadataExists = Files.exists(yaml, new LinkOption[0]) || Files.exists(json, new LinkOption[0]);
        if (propsExist == metadataExists) {
            return propsExist;
        }
        if (metadataExists) {
            throw new RuntimeException(a + " includes Quarkus extension metadata but not " + properties);
        }
        throw new RuntimeException(a + " includes Quarkus extension properties but not META-INF/quarkus-extension.yaml");
    }

    private /* synthetic */ ArtifactCoords lambda$execute$0(Artifact rtArtifact, PathVisit visit) {
        if (visit == null) {
            return null;
        }
        return this.readDeploymentCoords(visit.getPath(), rtArtifact);
    }
}

