/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.decomposer.maven.MojoMessageWriter;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformConfig;
import io.quarkus.bom.platform.ProjectDependencyFilterConfig;
import io.quarkus.bom.platform.SbomConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.DependencyTreeVisitor;
import io.quarkus.domino.ProjectDependencyConfig;
import io.quarkus.domino.ProjectDependencyResolver;
import io.quarkus.domino.RhVersionPattern;
import io.quarkus.domino.manifest.SbomGeneratingDependencyVisitor;
import io.quarkus.domino.manifest.SbomGenerator;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.paths.PathTree;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="dependencies-to-build", threadSafe=true, requiresProject=false)
public class DependenciesToBuildMojo
extends AbstractMojo {
    @Component
    RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Parameter(required=false, defaultValue="${project.file}")
    File projectFile;
    @Parameter(required=true, property="bom", defaultValue="${project.groupId}:${project.artifactId}::pom:${project.version}")
    String bom;
    @Parameter(required=true, property="level", defaultValue="-1")
    int level = -1;
    @Parameter(required=false, property="includeNonManaged")
    Boolean includeNonManaged;
    @Parameter(required=false, property="logArtifactsToBuild")
    boolean logArtifactsToBuild = true;
    @Parameter(required=false, property="logModulesToBuild")
    boolean logModulesToBuild;
    @Parameter(required=false, property="logTrees")
    boolean logTrees;
    @Parameter(required=false, property="logTreesFor")
    String logTreesFor;
    @Parameter(required=false, property="logRemaining")
    boolean logRemaining;
    @Parameter(required=false, property="logSummary")
    boolean logSummary = true;
    @Parameter(required=false, property="logNonManagedVisited")
    boolean logNonManagedVisited;
    @Parameter(property="outputFile", required=false)
    File outputFile;
    @Parameter(property="appendOutput", required=false, defaultValue="false")
    boolean appendOutput;
    @Parameter(property="logCodeRepos", required=false)
    boolean logCodeRepos;
    @Parameter(property="logCodeRepoGraph", required=false)
    boolean logCodeRepoGraph;
    @Parameter(property="excludeParentPoms", required=false)
    boolean excludeParentPoms;
    @Parameter(property="excludeBomImports", required=false)
    boolean excludeBomImports;
    @Parameter(required=false)
    PlatformConfig platformConfig;
    @Parameter(required=false)
    ProjectDependencyFilterConfig dependenciesToBuild;
    @Parameter(required=false, property="legacyScmLocator")
    boolean legacyScmLocator;
    @Parameter(required=false, property="recipeRepos")
    List<String> recipeRepos;
    @Parameter(required=false, property="warnOnMissingScm")
    boolean warnOnMissingScm;
    @Parameter(property="includeAlreadyBuilt", required=false)
    boolean includeAlreadyBuilt;
    @Parameter(required=false, property="manifest")
    boolean manifest;
    @Parameter(required=false, property="manifestDependencies", defaultValue="graph")
    String manifestDependencies;
    @Deprecated(forRemoval=true)
    @Parameter(required=false, property="flatManifest")
    boolean flatManifest;
    @Parameter(required=false, property="redhatSupported")
    boolean redhatSupported;
    @Parameter(required=false)
    SbomConfig.ProductConfig productInfo;
    private Set<ArtifactCoords> targetBomConstraints;
    private MavenArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactCoords targetBomCoords = ArtifactCoords.fromString((String)this.bom);
        if (PlatformArtifacts.isCatalogArtifactId((String)targetBomCoords.getArtifactId())) {
            targetBomCoords = ArtifactCoords.pom((String)targetBomCoords.getGroupId(), (String)PlatformArtifacts.ensureBomArtifactId((String)targetBomCoords.getArtifactId()), (String)targetBomCoords.getVersion());
        } else if (!targetBomCoords.getType().equals("pom")) {
            targetBomCoords = ArtifactCoords.pom((String)targetBomCoords.getGroupId(), (String)targetBomCoords.getArtifactId(), (String)targetBomCoords.getVersion());
        }
        this.debug("Quarkus platform BOM %s", targetBomCoords);
        ArtifactCoords catalogCoords = ArtifactCoords.of((String)targetBomCoords.getGroupId(), (String)PlatformArtifacts.ensureCatalogArtifactId((String)targetBomCoords.getArtifactId()), (String)targetBomCoords.getVersion(), (String)"json", (String)targetBomCoords.getVersion());
        this.debug("Quarkus extension catalog %s", catalogCoords);
        try {
            this.resolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).setWorkspaceDiscovery(this.projectFile != null)).setPreferPomsFromWorkspace(this.projectFile != null)).setCurrentProject(this.projectFile == null ? null : this.projectFile.toString())).build();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
        List<Dependency> targetBomManagedDeps = this.getBomConstraints(targetBomCoords);
        this.targetBomConstraints = this.toCoordsSet(targetBomManagedDeps);
        ExtensionCatalog catalog = this.resolveCatalog(catalogCoords);
        Collection<ArtifactCoords> rootArtifacts = this.getExtensionArtifacts(catalog);
        Collection<ArtifactCoords> otherDescriptorCoords = DependenciesToBuildMojo.getOtherMemberDescriptorCoords(catalog);
        List<Object> nonProjectBoms = List.of();
        if (!otherDescriptorCoords.isEmpty()) {
            if (targetBomCoords.getArtifactId().equals("quarkus-bom")) {
                if (!this.isManifestMode()) {
                    HashSet<ArtifactCoords> collectedTargetDeps = new HashSet<ArtifactCoords>(rootArtifacts);
                    for (ArtifactCoords descrCoords : otherDescriptorCoords) {
                        ExtensionCatalog otherCatalog = this.resolveCatalog(descrCoords);
                        Collection<ArtifactCoords> extensions = this.getExtensionArtifacts(otherCatalog);
                        if (extensions.isEmpty()) continue;
                        ArtifactCoords otherBomCoords = otherCatalog.getBom();
                        List<Dependency> otherBomDeps = this.getBomConstraints(otherBomCoords);
                        Set<ArtifactCoords> otherBomConstraints = this.toCoordsSet(otherBomDeps);
                        ArrayList<Dependency> managedDeps = new ArrayList<Dependency>(targetBomManagedDeps.size() + otherBomDeps.size());
                        managedDeps.addAll(targetBomManagedDeps);
                        managedDeps.addAll(otherBomDeps);
                        for (ArtifactCoords e : extensions) {
                            DependencyNode node;
                            try {
                                node = this.resolver.collectManagedDependencies((Artifact)DependenciesToBuildMojo.toAetherArtifact(e), List.of(), managedDeps, List.of(), List.of(), new String[0]).getRoot();
                            }
                            catch (BootstrapMavenException ex) {
                                throw new RuntimeException(ex);
                            }
                            this.collectManagedByTargetBom(node, otherBomConstraints, collectedTargetDeps, e);
                        }
                    }
                    rootArtifacts = collectedTargetDeps;
                }
            } else {
                ArtifactCoords generatedCoreBomCoords = null;
                String coreDescriptorArtifactId = PlatformArtifacts.ensureCatalogArtifactId((String)"quarkus-bom");
                for (ArtifactCoords c : otherDescriptorCoords) {
                    if (!c.getArtifactId().equals(coreDescriptorArtifactId)) continue;
                    generatedCoreBomCoords = PlatformArtifacts.ensureBomArtifact((ArtifactCoords)c);
                    break;
                }
                if (generatedCoreBomCoords == null) {
                    throw new MojoExecutionException("Failed to locate quarkus-bom among " + otherDescriptorCoords);
                }
                nonProjectBoms = List.of(generatedCoreBomCoords);
            }
        }
        ProjectDependencyConfig.Mutable depsConfigBuilder = ProjectDependencyConfig.builder().setProductInfo(SbomConfig.ProductConfig.toProductInfo((SbomConfig.ProductConfig)this.productInfo)).setProjectBom(targetBomCoords).setNonProjectBoms(nonProjectBoms).setProjectArtifacts(rootArtifacts).setIncludeGroupIds((Collection)this.dependenciesToBuild.getIncludeGroupIds()).setIncludeKeys((Collection)this.dependenciesToBuild.getIncludeKeys()).setIncludeArtifacts((Collection)this.dependenciesToBuild.getIncludeArtifacts()).setExcludePatterns((Collection)this.dependenciesToBuild.getExcludeArtifacts()).setExcludeGroupIds((Collection)this.dependenciesToBuild.getExcludeGroupIds()).setExcludeKeys((Collection)this.dependenciesToBuild.getExcludeKeys()).setExcludeBomImports(this.excludeBomImports).setExcludeParentPoms(this.excludeParentPoms).setLevel(this.level).setLogArtifactsToBuild(this.logArtifactsToBuild).setLogCodeRepoTree(this.logCodeRepoGraph).setLogCodeRepos(this.logCodeRepos).setLogModulesToBuild(this.logModulesToBuild).setLogNonManagedVisited(this.logNonManagedVisited).setLogRemaining(this.logRemaining).setLogSummary(this.logSummary).setLogTrees(this.logTrees).setLogTreesFor(this.logTreesFor).setIncludeAlreadyBuilt(this.includeAlreadyBuilt).setLegacyScmLocator(this.legacyScmLocator).setRecipeRepos(this.recipeRepos).setWarnOnMissingScm(this.warnOnMissingScm);
        if (this.includeNonManaged != null) {
            depsConfigBuilder.setIncludeNonManaged(this.includeNonManaged.booleanValue());
        }
        if (this.manifest) {
            if ("none".equals(this.manifestDependencies)) {
                this.flatManifest = true;
            } else if (this.manifestDependencies.equals("tree")) {
                depsConfigBuilder.setVerboseGraphs(false);
            } else {
                if (!this.manifestDependencies.equals("graph")) {
                    throw new MojoExecutionException("Unrecognized value '" + this.manifestDependencies + "' for parameter manifestDependencies. Supported values include graph, tree, none");
                }
                depsConfigBuilder.setVerboseGraphs(true);
            }
        }
        ProjectDependencyConfig dependencyConfig = depsConfigBuilder.build();
        ProjectDependencyResolver.Builder depsResolver = ProjectDependencyResolver.builder().setArtifactResolver(this.resolver).setMessageWriter((MessageWriter)new MojoMessageWriter(this.getLog())).setLogOutputFile(this.isManifestMode() ? null : (this.outputFile == null ? null : this.outputFile.toPath())).setAppendOutput(this.appendOutput).setDependencyConfig(dependencyConfig);
        if (this.manifest || this.flatManifest) {
            SbomGeneratingDependencyVisitor sbomGenerator = new SbomGeneratingDependencyVisitor(SbomGenerator.builder().setArtifactResolver(this.resolver).setOutputFile(this.outputFile == null ? null : this.outputFile.toPath()).setEnableTransformers(false).setRecordDependencies(!this.flatManifest).setProductInfo(dependencyConfig.getProductInfo()), dependencyConfig);
            depsResolver.addDependencyTreeVisitor((DependencyTreeVisitor)sbomGenerator).build().resolveDependencies();
        } else {
            depsResolver.build().log();
        }
    }

    private Set<ArtifactCoords> toCoordsSet(List<Dependency> targetBomManagedDeps) {
        HashSet<ArtifactCoords> targetBomConstraints = new HashSet<ArtifactCoords>(targetBomManagedDeps.size());
        for (Dependency d : targetBomManagedDeps) {
            targetBomConstraints.add(DependenciesToBuildMojo.toCoords(d.getArtifact()));
        }
        return targetBomConstraints;
    }

    private void collectManagedByTargetBom(DependencyNode node, Set<ArtifactCoords> otherBomConstraints, Set<ArtifactCoords> collected, ArtifactCoords extension) {
        ArtifactCoords coords = DependenciesToBuildMojo.toCoords(node.getArtifact());
        if (this.isExcluded(coords)) {
            return;
        }
        if (this.targetBomConstraints.contains(coords)) {
            if (!RhVersionPattern.isRhVersion((String)coords.getVersion()) && collected.add(coords)) {
                this.getLog().info((CharSequence)String.format("Collected %s as a dependency of %s managed by the quarkus-bom", coords, extension));
            }
        } else if (!Boolean.TRUE.equals(this.includeNonManaged) && !otherBomConstraints.contains(coords)) {
            return;
        }
        for (DependencyNode c : node.getChildren()) {
            this.collectManagedByTargetBom(c, otherBomConstraints, collected, extension);
        }
    }

    private Collection<ArtifactCoords> getExtensionArtifacts(ExtensionCatalog catalog) throws MojoExecutionException {
        ArrayList<ArtifactCoords> supported = new ArrayList<ArtifactCoords>();
        for (Extension ext : catalog.getExtensions()) {
            ArtifactCoords rtArtifact = ext.getArtifact();
            if (this.isExcluded(rtArtifact) || this.redhatSupported && !ext.getMetadata().containsKey("redhat-support")) continue;
            supported.add(ext.getArtifact());
            ArtifactCoords deploymentCoords = ArtifactCoords.jar((String)rtArtifact.getGroupId(), (String)(rtArtifact.getArtifactId() + "-deployment"), (String)rtArtifact.getVersion());
            if (!this.targetBomConstraints.contains(deploymentCoords)) {
                Path rtJar;
                try {
                    rtJar = this.resolver.resolve((Artifact)DependenciesToBuildMojo.toAetherArtifact(rtArtifact)).getArtifact().getFile().toPath();
                }
                catch (BootstrapMavenException e1) {
                    throw new MojoExecutionException("Failed to resolve " + rtArtifact, (Exception)((Object)e1));
                }
                deploymentCoords = (ArtifactCoords)PathTree.ofDirectoryOrArchive((Path)rtJar).apply("META-INF/quarkus-extension.properties", visit -> {
                    if (visit == null) {
                        return null;
                    }
                    Properties props = new Properties();
                    try (BufferedReader reader = Files.newBufferedReader(visit.getPath());){
                        props.load(reader);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    String str = props.getProperty("deployment-artifact");
                    return str == null ? null : ArtifactCoords.fromString((String)str);
                });
                if (deploymentCoords == null) {
                    throw new MojoExecutionException("Failed to determine the corresponding deployment artifact for " + rtArtifact.toCompactCoords());
                }
            }
            supported.add(deploymentCoords);
        }
        return supported;
    }

    private boolean isManifestMode() {
        return this.manifest || this.flatManifest;
    }

    private List<Dependency> getBomConstraints(ArtifactCoords bomCoords) throws MojoExecutionException {
        List managedDeps;
        DefaultArtifact bomArtifact = new DefaultArtifact(bomCoords.getGroupId(), bomCoords.getArtifactId(), "", "pom", bomCoords.getVersion());
        try {
            managedDeps = this.resolver.resolveDescriptor((Artifact)bomArtifact).getManagedDependencies();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve the descriptor of " + bomCoords, (Exception)((Object)e));
        }
        if (managedDeps.isEmpty()) {
            throw new MojoExecutionException(bomCoords.toCompactCoords() + " does not include any managed dependency or its descriptor could not be read");
        }
        return managedDeps;
    }

    private ExtensionCatalog resolveCatalog(ArtifactCoords catalogCoords) throws MojoExecutionException {
        ExtensionCatalog catalog;
        Path jsonPath;
        try {
            jsonPath = this.resolver.resolve((Artifact)DependenciesToBuildMojo.toAetherArtifact(catalogCoords)).getArtifact().getFile().toPath();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve the extension catalog", (Exception)((Object)e));
        }
        try {
            this.debug("Parsing extension catalog %s", jsonPath);
            catalog = ExtensionCatalog.fromFile((Path)jsonPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse " + jsonPath, (Exception)e);
        }
        return catalog;
    }

    private static DefaultArtifact toAetherArtifact(ArtifactCoords a) {
        return new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getType(), a.getVersion());
    }

    private void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            if (args.length == 0) {
                this.getLog().debug((CharSequence)msg);
            } else {
                this.getLog().debug((CharSequence)String.format(msg, args));
            }
        }
    }

    private boolean isExcluded(ArtifactCoords coords) {
        return this.dependenciesToBuild != null && (this.dependenciesToBuild.getExcludeGroupIds().contains(coords.getGroupId()) || this.dependenciesToBuild.getExcludeKeys().contains(coords.getKey()) || this.dependenciesToBuild.getExcludeArtifacts().contains(coords));
    }

    private static ArtifactCoords toCoords(Artifact a) {
        return ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion());
    }

    private static Collection<ArtifactCoords> getOtherMemberDescriptorCoords(ExtensionCatalog catalog) {
        Map map = catalog.getMetadata();
        if (map == null) {
            return List.of();
        }
        Object o = map.get("platform-release");
        if (!(o instanceof Map)) {
            return List.of();
        }
        if (!((o = ((Map)o).get("members")) instanceof List)) {
            return List.of();
        }
        List list = (List)o;
        ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>(list.size());
        list.forEach(i -> {
            if (!i.equals(catalog.getId())) {
                result.add(ArtifactCoords.fromString((String)i.toString()));
            }
        });
        return result;
    }
}

