/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.metrics.micrometer;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.opentracing.contrib.api.SpanData;
import io.opentracing.contrib.metrics.AbstractMetricsReporter;
import io.opentracing.contrib.metrics.MetricLabel;
import io.opentracing.contrib.metrics.MetricsReporter;
import io.opentracing.contrib.metrics.label.BaggageMetricLabel;
import io.opentracing.contrib.metrics.label.ConstMetricLabel;
import io.opentracing.contrib.metrics.label.TagMetricLabel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MicrometerMetricsReporter
extends AbstractMetricsReporter
implements MetricsReporter {
    private final String name;
    private final Duration sla;
    private final Duration minimumExpectedValue;
    private final Duration maximumExpectedValue;
    private final double[] percentiles;
    private final boolean publishPercentileHistogram;
    private final MeterRegistry registry;

    protected MicrometerMetricsReporter(String name, List<MetricLabel> labels, MeterRegistry registry, Duration sla, Duration minimumExpectedValue, Duration maximumExpectedValue, boolean publishPercentileHistogram, double ... percentiles) {
        super(labels);
        this.name = name;
        this.registry = registry;
        this.sla = sla;
        this.minimumExpectedValue = minimumExpectedValue;
        this.maximumExpectedValue = maximumExpectedValue;
        this.publishPercentileHistogram = publishPercentileHistogram;
        this.percentiles = percentiles;
    }

    public void reportSpan(SpanData spanData) {
        boolean skip = Arrays.stream(this.metricLabels).anyMatch(m -> m.value(spanData) == null);
        if (skip) {
            return;
        }
        List tags = Arrays.stream(this.metricLabels).map(m -> new ImmutableTag(m.name(), m.value(spanData).toString())).collect(Collectors.toList());
        Timer timer = this.registry.find(this.name).tags(tags).timer();
        if (null != timer) {
            timer.record(spanData.getDuration(), TimeUnit.MICROSECONDS);
            return;
        }
        Timer.Builder builder = Timer.builder((String)this.name).tags(tags);
        if (this.publishPercentileHistogram) {
            builder.publishPercentileHistogram();
        }
        if (null != this.percentiles) {
            builder.publishPercentiles(this.percentiles);
        }
        if (null != this.sla) {
            builder.sla(new Duration[]{this.sla});
        }
        if (null != this.minimumExpectedValue) {
            builder.minimumExpectedValue(this.minimumExpectedValue);
        }
        if (null != this.maximumExpectedValue) {
            builder.maximumExpectedValue(this.maximumExpectedValue);
        }
        builder.register(this.registry).record(spanData.getDuration(), TimeUnit.MICROSECONDS);
    }

    public static Builder newMetricsReporter() {
        return new Builder();
    }

    public static class Builder {
        private String name = "span";
        private Duration sla;
        private Duration minimumExpectedValue;
        private Duration maximumExpectedValue;
        private double[] percentiles;
        private boolean publishPercentileHistogram;
        private MeterRegistry registry = Metrics.globalRegistry;
        private List<MetricLabel> metricLabels = new ArrayList<MetricLabel>();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCustomLabel(MetricLabel label) {
            this.metricLabels.add(label);
            return this;
        }

        public Builder withConstLabel(String name, Object value) {
            this.metricLabels.add((MetricLabel)new ConstMetricLabel(name, value));
            return this;
        }

        public Builder withTagLabel(String name, Object defaultValue) {
            this.metricLabels.add((MetricLabel)new TagMetricLabel(name, defaultValue));
            return this;
        }

        public Builder withBaggageLabel(String name, Object defaultValue) {
            this.metricLabels.add((MetricLabel)new BaggageMetricLabel(name, defaultValue));
            return this;
        }

        public Builder withSla(Duration sla) {
            this.sla = sla;
            return this;
        }

        public Builder withMinimumExpectedValue(Duration minimumExpectedValue) {
            this.minimumExpectedValue = minimumExpectedValue;
            return this;
        }

        public Builder withMaximumExpectedValue(Duration maximumExpectedValue) {
            this.maximumExpectedValue = maximumExpectedValue;
            return this;
        }

        public Builder withPercentiles(double ... percentiles) {
            this.percentiles = percentiles;
            return this;
        }

        public Builder enablePercentileHistogram() {
            this.publishPercentileHistogram = true;
            return this;
        }

        public Builder disablePercentileHistogram() {
            this.publishPercentileHistogram = false;
            return this;
        }

        public Builder withRegistry(MeterRegistry registry) {
            this.registry = registry;
            return this;
        }

        public MicrometerMetricsReporter build() {
            return new MicrometerMetricsReporter(this.name, this.metricLabels, this.registry, this.sla, this.minimumExpectedValue, this.maximumExpectedValue, this.publishPercentileHistogram, this.percentiles);
        }
    }
}

