/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.micrometer.v1_5;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import io.opentelemetry.instrumentation.micrometer.v1_5.Bridging;
import io.opentelemetry.instrumentation.micrometer.v1_5.DoubleMeasurementRecorder;
import io.opentelemetry.instrumentation.micrometer.v1_5.LongMeasurementRecorder;
import io.opentelemetry.instrumentation.micrometer.v1_5.RemovableMeter;
import io.opentelemetry.instrumentation.micrometer.v1_5.TimeUnitHelper;
import io.opentelemetry.instrumentation.micrometer.v1_5.UnsupportedReadLogger;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

final class OpenTelemetryLongTaskTimer
extends DefaultLongTaskTimer
implements RemovableMeter {
    private final DistributionStatisticConfig distributionStatisticConfig;
    private final ObservableLongUpDownCounter observableActiveTasks;
    private final ObservableDoubleUpDownCounter observableDuration;

    OpenTelemetryLongTaskTimer(Meter.Id id, NamingConvention namingConvention, Clock clock, TimeUnit baseTimeUnit, DistributionStatisticConfig distributionStatisticConfig, Meter otelMeter) {
        super(id, clock, baseTimeUnit, distributionStatisticConfig, false);
        this.distributionStatisticConfig = distributionStatisticConfig;
        String name = Bridging.name(id, namingConvention);
        Attributes attributes = Bridging.tagsAsAttributes(id, namingConvention);
        this.observableActiveTasks = otelMeter.upDownCounterBuilder(name + ".active").setDescription(Bridging.description(id)).setUnit("{tasks}").buildWithCallback(new LongMeasurementRecorder<OpenTelemetryLongTaskTimer>(this, DefaultLongTaskTimer::activeTasks, attributes));
        this.observableDuration = otelMeter.upDownCounterBuilder(name + ".duration").ofDoubles().setDescription(Bridging.description(id)).setUnit(TimeUnitHelper.getUnitString(baseTimeUnit)).buildWithCallback(new DoubleMeasurementRecorder<OpenTelemetryLongTaskTimer>(this, t -> t.duration(t.baseTimeUnit()), attributes));
    }

    public Iterable<Measurement> measure() {
        UnsupportedReadLogger.logWarning();
        return Collections.emptyList();
    }

    @Override
    public void onRemove() {
        this.observableActiveTasks.close();
        this.observableDuration.close();
    }

    boolean isUsingMicrometerHistograms() {
        return this.distributionStatisticConfig.isPublishingPercentiles() || this.distributionStatisticConfig.isPublishingHistogram();
    }
}

