/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.ScoredValue;
import io.lettuce.core.ScoredValueScanCursor;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.output.ScanOutput;
import java.nio.ByteBuffer;

public class ScoredValueScanOutput<K, V>
extends ScanOutput<K, V, ScoredValueScanCursor<V>> {
    private V value;
    private boolean hasValue;

    public ScoredValueScanOutput(RedisCodec<K, V> codec) {
        super(codec, new ScoredValueScanCursor());
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (!this.hasValue) {
            this.value = this.codec.decodeValue(bytes);
            this.hasValue = true;
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        if (this.hasValue) {
            ((ScoredValueScanCursor)this.output).getValues().add(ScoredValue.just(number, this.value));
        }
        this.value = null;
        this.hasValue = false;
    }
}

