/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.AclCategory;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.ArrayList;
import java.util.List;

public class AclSetuserArgs
implements CompositeArgument {
    private boolean active;
    private List<String> keyPatterns;
    private boolean allKeys;
    private boolean resetKeys;
    private List<String> channelPatterns;
    private boolean allChannels;
    private boolean resetChannels;
    private List<CommandSubcommandPair> addCommands;
    private boolean allCommands;
    private List<CommandSubcommandPair> removeCommands;
    private boolean noCommands;
    private List<AclCategory> addCategories;
    private List<AclCategory> removeCategories;
    private boolean nopass;
    private List<String> addPasswords;
    private List<String> addHashedPasswords;
    private List<String> removePasswords;
    private List<String> removeHashedPasswords;
    private boolean reset;

    public AclSetuserArgs on() {
        this.active = true;
        return this;
    }

    public AclSetuserArgs off() {
        this.active = false;
        return this;
    }

    public AclSetuserArgs keyPattern(String keyPattern) {
        if (this.keyPatterns == null) {
            this.keyPatterns = new ArrayList<String>();
        }
        this.keyPatterns.add(keyPattern);
        return this;
    }

    public AclSetuserArgs allKeys() {
        this.allKeys = true;
        return this;
    }

    public AclSetuserArgs resetKeys() {
        this.resetKeys = true;
        return this;
    }

    public AclSetuserArgs channelPattern(String channelPattern) {
        if (this.channelPatterns == null) {
            this.channelPatterns = new ArrayList<String>();
        }
        this.channelPatterns.add(channelPattern);
        return this;
    }

    public AclSetuserArgs allChannels() {
        this.allChannels = true;
        return this;
    }

    public AclSetuserArgs resetChannels() {
        this.resetChannels = true;
        return this;
    }

    public AclSetuserArgs addCommand(CommandType command) {
        return this.addCommand(command, null);
    }

    public AclSetuserArgs addCommand(CommandType command, ProtocolKeyword subCommand) {
        if (this.addCommands == null) {
            this.addCommands = new ArrayList<CommandSubcommandPair>();
        }
        this.addCommands.add(new CommandSubcommandPair(command, subCommand));
        return this;
    }

    public AclSetuserArgs allCommands() {
        this.allCommands = true;
        return this;
    }

    public AclSetuserArgs removeCommand(CommandType command) {
        return this.removeCommand(command, null);
    }

    public AclSetuserArgs removeCommand(CommandType command, ProtocolKeyword subCommand) {
        if (this.removeCommands == null) {
            this.removeCommands = new ArrayList<CommandSubcommandPair>();
        }
        this.removeCommands.add(new CommandSubcommandPair(command, subCommand));
        return this;
    }

    public AclSetuserArgs noCommands() {
        this.noCommands = false;
        return this;
    }

    public AclSetuserArgs addCategory(AclCategory category) {
        if (this.addCategories == null) {
            this.addCategories = new ArrayList<AclCategory>();
        }
        this.addCategories.add(category);
        return this;
    }

    public AclSetuserArgs removeCategory(AclCategory category) {
        if (this.removeCategories == null) {
            this.removeCategories = new ArrayList<AclCategory>();
        }
        this.removeCategories.add(category);
        return this;
    }

    public AclSetuserArgs nopass() {
        this.nopass = true;
        return this;
    }

    public AclSetuserArgs addPassword(String password) {
        if (this.addPasswords == null) {
            this.addPasswords = new ArrayList<String>();
        }
        this.addPasswords.add(password);
        return this;
    }

    public AclSetuserArgs addHashedPassword(String hashedPassword) {
        if (this.addHashedPasswords == null) {
            this.addHashedPasswords = new ArrayList<String>();
        }
        this.addHashedPasswords.add(hashedPassword);
        return this;
    }

    public AclSetuserArgs removePassword(String password) {
        if (this.removePasswords == null) {
            this.removePasswords = new ArrayList<String>();
        }
        this.removePasswords.add(password);
        return this;
    }

    public AclSetuserArgs removeHashedPassword(String hashedPassword) {
        if (this.removeHashedPasswords == null) {
            this.removeHashedPasswords = new ArrayList<String>();
        }
        this.removeHashedPasswords.add(hashedPassword);
        return this;
    }

    public AclSetuserArgs reset() {
        this.reset = true;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.reset) {
            args.add(CommandKeyword.RESET);
            return;
        }
        if (this.active) {
            args.add(CommandKeyword.ON);
        } else {
            args.add(CommandKeyword.OFF);
        }
        if (this.allKeys) {
            args.add(CommandKeyword.ALLKEYS);
        }
        if (this.resetKeys) {
            args.add(CommandKeyword.RESETKEYS);
        }
        if (this.keyPatterns != null) {
            for (String glob : this.keyPatterns) {
                args.add("~" + glob);
            }
        }
        if (this.allChannels) {
            args.add(CommandKeyword.ALLCHANNELS);
        }
        if (this.resetChannels) {
            args.add(CommandKeyword.RESETCHANNELS);
        }
        if (this.channelPatterns != null) {
            for (String glob : this.channelPatterns) {
                args.add("&" + glob);
            }
        }
        if (this.allCommands) {
            args.add(CommandKeyword.ALLCOMMANDS);
        }
        if (this.addCommands != null) {
            for (CommandSubcommandPair command : this.addCommands) {
                if (command.getSubCommand() == null) {
                    args.add("+" + command.getCommand().name());
                    continue;
                }
                args.add("+" + command.getCommand().name() + "|" + command.getSubCommand().name());
            }
        }
        if (this.noCommands) {
            args.add(CommandKeyword.NOCOMMANDS);
        }
        if (this.removeCommands != null) {
            for (CommandSubcommandPair command : this.removeCommands) {
                if (command.getSubCommand() == null) {
                    args.add("-" + command.getCommand().name());
                    continue;
                }
                args.add("-" + command.getCommand().name() + "|" + command.getSubCommand().name());
            }
        }
        if (this.removeCategories != null) {
            for (AclCategory category : this.addCategories) {
                args.add("+@" + category.name());
            }
        }
        if (this.removeCategories != null) {
            for (AclCategory category : this.removeCategories) {
                args.add("-@" + category.name());
            }
        }
        if (this.nopass) {
            args.add(CommandKeyword.NOPASS);
        }
        if (this.addPasswords != null) {
            for (String password : this.addPasswords) {
                args.add(">" + password);
            }
        }
        if (this.addHashedPasswords != null) {
            for (String password : this.addHashedPasswords) {
                args.add("#" + password);
            }
        }
        if (this.removePasswords != null) {
            for (String password : this.removePasswords) {
                args.add("<" + password);
            }
        }
        if (this.removeHashedPasswords != null) {
            for (String password : this.removeHashedPasswords) {
                args.add("!" + password);
            }
        }
    }

    private static class CommandSubcommandPair {
        private final CommandType command;
        private final ProtocolKeyword subCommand;

        private CommandSubcommandPair(CommandType command, ProtocolKeyword subCommand) {
            this.command = command;
            this.subCommand = subCommand;
        }

        public CommandType getCommand() {
            return this.command;
        }

        public ProtocolKeyword getSubCommand() {
            return this.subCommand;
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static AclSetuserArgs on() {
            return new AclSetuserArgs().on();
        }

        public static AclSetuserArgs off() {
            return new AclSetuserArgs().off();
        }

        public static AclSetuserArgs keyPattern(String keyPattern) {
            return new AclSetuserArgs().keyPattern(keyPattern);
        }

        public static AclSetuserArgs allKeys() {
            return new AclSetuserArgs().allKeys();
        }

        public static AclSetuserArgs resetKeys() {
            return new AclSetuserArgs().resetKeys();
        }

        public static AclSetuserArgs channelPattern(String channelPattern) {
            return new AclSetuserArgs().channelPattern(channelPattern);
        }

        public static AclSetuserArgs allChannels() {
            return new AclSetuserArgs().allChannels();
        }

        public static AclSetuserArgs resetChannels() {
            return new AclSetuserArgs().resetChannels();
        }

        public static AclSetuserArgs addCommand(CommandType command) {
            return new AclSetuserArgs().addCommand(command);
        }

        public static AclSetuserArgs addCommand(CommandType command, ProtocolKeyword subCommand) {
            return new AclSetuserArgs().addCommand(command, subCommand);
        }

        public static AclSetuserArgs allCommands() {
            return new AclSetuserArgs().allCommands();
        }

        public static AclSetuserArgs removeCommand(CommandType command) {
            return new AclSetuserArgs().removeCommand(command);
        }

        public static AclSetuserArgs removeCommand(CommandType command, ProtocolKeyword subCommand) {
            return new AclSetuserArgs().removeCommand(command, subCommand);
        }

        public static AclSetuserArgs noCommands() {
            return new AclSetuserArgs().noCommands();
        }

        public static AclSetuserArgs addCategory(AclCategory category) {
            return new AclSetuserArgs().addCategory(category);
        }

        public static AclSetuserArgs removeCategory(AclCategory category) {
            return new AclSetuserArgs().removeCategory(category);
        }

        public static AclSetuserArgs nopass() {
            return new AclSetuserArgs().nopass();
        }

        public static AclSetuserArgs addPassword(String password) {
            return new AclSetuserArgs().addPassword(password);
        }

        public static AclSetuserArgs addHashedPassword(String hashedPassword) {
            return new AclSetuserArgs().addHashedPassword(hashedPassword);
        }

        public static AclSetuserArgs removePassword(String password) {
            return new AclSetuserArgs().removePassword(password);
        }

        public static AclSetuserArgs removeHashedPassword(String hashedPassword) {
            return new AclSetuserArgs().removeHashedPassword(hashedPassword);
        }

        public static AclSetuserArgs reset() {
            return new AclSetuserArgs().reset();
        }
    }
}

