/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.interval;

import io.hypersistence.utils.hibernate.type.ImmutableType;
import io.hypersistence.utils.hibernate.type.util.Configuration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Period;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.spi.TypeBootstrapContext;
import org.postgresql.util.PGInterval;

public class PostgreSQLPeriodType
extends ImmutableType<Period> {
    public static final PostgreSQLPeriodType INSTANCE = new PostgreSQLPeriodType();

    public PostgreSQLPeriodType() {
        super(Period.class);
    }

    public PostgreSQLPeriodType(TypeBootstrapContext typeBootstrapContext) {
        super(Period.class, new Configuration(typeBootstrapContext.getConfigurationSettings()));
    }

    @Override
    protected Period get(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws SQLException {
        PGInterval interval = (PGInterval)rs.getObject(names[0]);
        if (interval == null) {
            return null;
        }
        int years = interval.getYears();
        int months = interval.getMonths();
        int days = interval.getDays();
        return Period.ofYears(years).plusMonths(months).plusDays(days);
    }

    @Override
    protected void set(PreparedStatement st, Period value, int index, SharedSessionContractImplementor session) throws SQLException {
        if (value == null) {
            st.setNull(index, 1111);
        } else {
            int days = value.getDays();
            int months = value.getMonths();
            int years = value.getYears();
            st.setObject(index, new PGInterval(years, months, days, 0, 0, 0.0));
        }
    }

    public int[] sqlTypes() {
        return new int[]{1111};
    }
}

