/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.metrics;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.config.Config;
import io.helidon.http.HttpException;
import io.helidon.http.Status;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.observe.metrics.MetricsFeature;
import io.helidon.webserver.observe.metrics.MetricsObserverConfig;
import io.helidon.webserver.observe.spi.Observer;
import io.helidon.webserver.spi.ServerFeature;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@RuntimeType.PrototypedBy(value=MetricsObserverConfig.class)
public class MetricsObserver
implements Observer,
RuntimeType.Api<MetricsObserverConfig> {
    private final MetricsObserverConfig config;
    private MetricsFeature metricsFeature;

    private MetricsObserver(MetricsObserverConfig config) {
        this.config = config;
        this.metricsFeature = new MetricsFeature(config);
    }

    public static MetricsObserverConfig.Builder builder() {
        return MetricsObserverConfig.builder();
    }

    public static MetricsObserver create(MetricsObserverConfig config) {
        return new MetricsObserver(config);
    }

    public static MetricsObserver create(Consumer<MetricsObserverConfig.Builder> consumer) {
        return ((MetricsObserverConfig.Builder)MetricsObserver.builder().update(consumer)).build();
    }

    public static MetricsObserver create() {
        return MetricsObserver.builder().build();
    }

    public static MetricsObserver create(Config config) {
        return ((MetricsObserverConfig.Builder)MetricsObserver.builder().config(config)).build();
    }

    public MetricsObserverConfig prototype() {
        return this.config;
    }

    public String type() {
        return "metrics";
    }

    public void register(ServerFeature.ServerFeatureContext featureContext, List<HttpRouting.Builder> observeEndpointRouting, UnaryOperator<String> endpointFunction) {
        String endpoint = (String)endpointFunction.apply(this.config.endpoint());
        if (this.config.enabled()) {
            for (HttpRouting.Builder routing : observeEndpointRouting) {
                this.metricsFeature.register(routing, endpoint);
            }
        } else {
            for (HttpRouting.Builder builder : observeEndpointRouting) {
                builder.any(endpoint + "/*", new Handler[]{(req, res) -> {
                    throw new HttpException("Metrics endpoint is disabled", Status.SERVICE_UNAVAILABLE_503, true);
                }});
            }
        }
    }

    public void configureVendorMetrics(HttpRouting.Builder rules) {
        this.metricsFeature.configureVendorMetrics(rules);
    }
}

