/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.health;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckType;
import io.helidon.microprofile.health.BuiltInHealthCheck;
import io.helidon.microprofile.health.HealthCheckProvider;
import io.helidon.microprofile.health.MpCheckWrapper;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.microprofile.servicecommon.HelidonRestCdiExtension;
import io.helidon.webserver.observe.health.HealthObserver;
import io.helidon.webserver.observe.health.HealthObserverConfig;
import io.helidon.webserver.observe.spi.Observer;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;

public class HealthCdiExtension
extends HelidonRestCdiExtension {
    private static final BuiltInHealthCheck BUILT_IN_HEALTH_CHECK_LITERAL = new BuiltInHealthCheck(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return BuiltInHealthCheck.class;
        }
    };
    private static final System.Logger LOGGER = System.getLogger(HealthCdiExtension.class.getName());

    public HealthCdiExtension() {
        super(LOGGER, new String[]{HealthCdiExtension.nestedConfigKey((String)"health"), "health"});
    }

    public void registerService(@Observes @Priority(value=1010) @Initialized(value=ApplicationScoped.class) Object event, ServerCdiExtension server) {
        server.addObserver((Observer)this.configure());
    }

    private HealthObserver configure() {
        List<Object> builtInsFilter;
        HealthObserverConfig.Builder builder = HealthObserver.builder();
        Config config = this.componentConfig();
        ((HealthObserverConfig.Builder)((HealthObserverConfig.Builder)builder.details(true)).endpoint("/health")).config((io.helidon.common.config.Config)config);
        CDI cdi = CDI.current();
        if (((Boolean)this.rootConfig().get("mp.health.disable-default-procedures").asBoolean().orElse((Object)false)).booleanValue()) {
            builder.useSystemServices(false);
            builtInsFilter = cdi.select(org.eclipse.microprofile.health.HealthCheck.class, new Annotation[]{BUILT_IN_HEALTH_CHECK_LITERAL}).stream().toList();
        } else {
            builtInsFilter = List.of();
        }
        cdi.select(org.eclipse.microprofile.health.HealthCheck.class, new Annotation[]{Liveness.Literal.INSTANCE}).stream().filter(hc -> !builtInsFilter.contains(hc)).forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.LIVENESS, it)));
        cdi.select(org.eclipse.microprofile.health.HealthCheck.class, new Annotation[]{Readiness.Literal.INSTANCE}).stream().filter(hc -> !builtInsFilter.contains(hc)).forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.READINESS, it)));
        cdi.select(org.eclipse.microprofile.health.HealthCheck.class, new Annotation[]{Startup.Literal.INSTANCE}).stream().filter(hc -> !builtInsFilter.contains(hc)).forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.STARTUP, it)));
        HelidonServiceLoader.create(ServiceLoader.load(HealthCheckProvider.class)).forEach(healthCheckProvider -> {
            healthCheckProvider.livenessChecks().forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.LIVENESS, it)));
            healthCheckProvider.readinessChecks().forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.READINESS, it)));
            healthCheckProvider.startupChecks().forEach(it -> builder.addCheck((HealthCheck)MpCheckWrapper.create(HealthCheckType.STARTUP, it)));
        });
        return builder.build();
    }
}

