/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import io.helidon.config.OverrideSources;
import io.helidon.config.mp.MpConfigImpl;
import io.helidon.config.mp.MpHelidonConfigSource;
import io.helidon.config.mp.SeConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.ConfigSource;

public final class MpConfig {
    private MpConfig() {
    }

    public static Config toHelidonConfig(org.eclipse.microprofile.config.Config mpConfig) {
        if (mpConfig instanceof Config) {
            return (Config)mpConfig;
        }
        if (mpConfig instanceof MpConfigImpl) {
            ConfigSource first;
            Iterator configSources = mpConfig.getConfigSources().iterator();
            ConfigSource configSource = first = configSources.hasNext() ? (ConfigSource)configSources.next() : null;
            if (!configSources.hasNext() && first instanceof MpHelidonConfigSource) {
                return ((MpHelidonConfigSource)first).unwrap();
            }
            Config mapper = Config.builder().sources((Supplier)ConfigSources.empty()).overrides((Supplier)OverrideSources.empty()).disableEnvironmentVariablesSource().disableSystemPropertiesSource().disableParserServices().disableFilterServices().disableCaching().disableValueResolving().changesExecutor(command -> {}).build();
            return new SeConfig(mapper, mpConfig);
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (ConfigSource configSource : mpConfig.getConfigSources()) {
            for (String propertyName : configSource.getPropertyNames()) {
                propertyMap.putIfAbsent(propertyName, configSource.getValue(propertyName));
            }
        }
        return Config.create((Supplier[])new Supplier[]{ConfigSources.create(propertyMap)});
    }
}

