/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.encryption;

import io.helidon.common.pki.Keys;
import io.helidon.config.Config;
import io.helidon.config.MissingValueException;
import io.helidon.config.encryption.ConfigEncryptionException;
import io.helidon.config.encryption.EncryptionUtil;
import io.helidon.config.spi.ConfigFilter;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Function;

public final class EncryptionFilter
implements ConfigFilter {
    static final String PREFIX_GCM = "${GCM=";
    static final String PREFIX_RSA = "${RSA-P=";
    private static final System.Logger LOGGER = System.getLogger(EncryptionFilter.class.getName());
    private static final String PREFIX_ALIAS = "${ALIAS=";
    private static final String PREFIX_CLEAR = "${CLEAR=";
    private final PrivateKey privateKey;
    private final char[] masterPassword;
    private final boolean requireEncryption;
    private final ConfigFilter clearFilter;
    private final ConfigFilter rsaFilter;
    private final ConfigFilter aesFilter;
    private final ConfigFilter aliasFilter;

    private EncryptionFilter(Builder builder, Config config) {
        if (builder.fromConfig) {
            this.requireEncryption = EncryptionUtil.getEnv("SECURE_CONFIG_REQUIRE_ENCRYPTION").map(Boolean::parseBoolean).or(() -> config.get("security.config.require-encryption").asBoolean().asOptional()).orElse(true);
            this.masterPassword = EncryptionUtil.resolveMasterPassword(this.requireEncryption, config).orElse(null);
            this.privateKey = EncryptionUtil.resolvePrivateKey(config.get("security.config.rsa")).orElse(null);
        } else {
            this.requireEncryption = builder.requireEncryption;
            this.privateKey = (PrivateKey)builder.privateKeyConfig.privateKey().orElseThrow(() -> new ConfigEncryptionException("Private key configuration is invalid"));
            this.masterPassword = builder.masterPassword;
        }
        if (null != this.privateKey && !(this.privateKey instanceof RSAPrivateKey)) {
            throw new ConfigEncryptionException("Private key must be an RSA private key, but is: " + this.privateKey.getClass().getName());
        }
        ConfigFilter noOp = (key, stringValue) -> stringValue;
        this.aesFilter = null == this.masterPassword ? noOp : (key, stringValue) -> this.decryptAes(this.masterPassword, stringValue);
        this.rsaFilter = null == this.privateKey ? noOp : (key, stringValue) -> this.decryptRsa(this.privateKey, stringValue);
        this.clearFilter = this::clearText;
        this.aliasFilter = (key, stringValue) -> this.aliased(stringValue, config);
    }

    private static String removePlaceholder(String prefix, String value) {
        return value.substring(prefix.length(), value.length() - 1);
    }

    public static Function<Config, ConfigFilter> fromConfig() {
        return EncryptionFilter.builder().fromConfig().buildProvider();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String apply(Config.Key key, String stringValue) {
        return this.maybeDecode(key, stringValue);
    }

    private String maybeDecode(Config.Key key, String value) {
        HashSet<String> processedValues = new HashSet<String>();
        do {
            processedValues.add(value);
            if (!value.startsWith("${") && !value.endsWith("}")) {
                return value;
            }
            value = this.aliasFilter.apply(key, value);
            value = this.clearFilter.apply(key, value);
            value = this.rsaFilter.apply(key, value);
        } while (!processedValues.contains(value = this.aesFilter.apply(key, value)));
        return value;
    }

    private String clearText(Config.Key key, String value) {
        if (value.startsWith(PREFIX_CLEAR)) {
            if (this.requireEncryption) {
                throw new ConfigEncryptionException("Key \"" + String.valueOf(key) + "\" is a clear text password, yet encryption is required");
            }
            return EncryptionFilter.removePlaceholder(PREFIX_CLEAR, value);
        }
        return value;
    }

    private String aliased(String value, Config config) {
        if (value.startsWith(PREFIX_ALIAS)) {
            String alias = EncryptionFilter.removePlaceholder(PREFIX_ALIAS, value);
            return (String)config.get(alias).asString().orElseThrow(MissingValueException.createSupplier((Config.Key)Config.Key.create((String)alias)));
        }
        return value;
    }

    private String decryptRsa(PrivateKey privateKey, String value) {
        if (value.startsWith(PREFIX_RSA)) {
            String b64Value = EncryptionFilter.removePlaceholder(PREFIX_RSA, value);
            try {
                return EncryptionUtil.decryptRsa(privateKey, b64Value);
            }
            catch (ConfigEncryptionException e) {
                LOGGER.log(System.Logger.Level.TRACE, () -> "Failed to decrypt " + value, (Throwable)e);
                return value;
            }
        }
        return value;
    }

    private String decryptAes(char[] masterPassword, String value) {
        if (value.startsWith(PREFIX_GCM)) {
            String b64Value = value.substring(PREFIX_GCM.length(), value.length() - 1);
            try {
                return EncryptionUtil.decryptAes(masterPassword, b64Value);
            }
            catch (ConfigEncryptionException e) {
                LOGGER.log(System.Logger.Level.TRACE, () -> "Failed to decrypt " + value, (Throwable)e);
                return value;
            }
        }
        return value;
    }

    public static class Builder {
        private boolean fromConfig = false;
        private char[] masterPassword;
        private Keys privateKeyConfig;
        private boolean requireEncryption = true;

        private Builder fromConfig() {
            this.fromConfig = true;
            return this;
        }

        public Builder masterPassword(char[] password) {
            this.masterPassword = Arrays.copyOf(password, password.length);
            return this;
        }

        public Builder privateKey(Keys privateKey) {
            this.privateKeyConfig = privateKey;
            return this;
        }

        public Builder requireEncryption(boolean require) {
            this.requireEncryption = require;
            return this;
        }

        public Function<Config, ConfigFilter> buildProvider() {
            return config -> new EncryptionFilter(this, (Config)config);
        }
    }
}

