/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.tls;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.config.Config;
import io.helidon.common.tls.TlsConfig;
import io.helidon.common.tls.TlsManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

@RuntimeType.PrototypedBy(value=TlsConfig.class)
public class Tls
implements RuntimeType.Api<TlsConfig> {
    public static final String ENDPOINT_IDENTIFICATION_HTTPS = "HTTPS";
    public static final String ENDPOINT_IDENTIFICATION_NONE = "NONE";
    private final SSLContext sslContext;
    private final SSLParameters sslParameters;
    private final SSLSocketFactory sslSocketFactory;
    private final SSLServerSocketFactory sslServerSocketFactory;
    private final boolean enabled;
    private final TlsConfig tlsConfig;
    private final TlsManager tlsManager;

    private Tls(TlsConfig config) {
        this.tlsConfig = Objects.requireNonNull(config);
        this.sslParameters = config.sslParameters().orElseThrow();
        this.enabled = config.enabled();
        if (config.enabled()) {
            this.tlsManager = config.manager();
            this.tlsManager.init(config);
            this.sslContext = this.tlsManager.sslContext();
            this.sslSocketFactory = this.sslContext.getSocketFactory();
            this.sslServerSocketFactory = this.sslContext.getServerSocketFactory();
        } else {
            this.sslContext = null;
            this.sslSocketFactory = null;
            this.sslServerSocketFactory = null;
            this.tlsManager = null;
        }
    }

    public static TlsConfig.Builder builder() {
        return TlsConfig.builder();
    }

    public static Tls create(Config config) {
        return ((TlsConfig.Builder)Tls.builder().config(config)).build();
    }

    public static Tls create(TlsConfig tlsConfig) {
        return new Tls(tlsConfig);
    }

    public static Tls create(Consumer<TlsConfig.Builder> consumer) {
        TlsConfig.Builder builder = TlsConfig.builder();
        consumer.accept(builder);
        return Tls.create(builder.buildPrototype());
    }

    public TlsConfig prototype() {
        return this.tlsConfig;
    }

    public final SSLEngine newEngine() {
        this.checkEnabled();
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setSSLParameters(this.sslParameters);
        return sslEngine;
    }

    public int hashCode() {
        if (this.enabled) {
            return 31 * Objects.hash(this.sslContext()) + Tls.hashCode(this.sslParameters());
        }
        return Objects.hash(Tls.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tls)) {
            return false;
        }
        Tls other = (Tls)o;
        if (!this.enabled() && !other.enabled()) {
            return true;
        }
        return this.sslContext().equals(other.sslContext()) && Tls.equals(this.sslParameters(), other.sslParameters());
    }

    public SSLServerSocket createServerSocket() {
        this.checkEnabled();
        try {
            SSLServerSocket socket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket();
            socket.setSSLParameters(this.sslParameters);
            return socket;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SSLSocket createSocket(List<String> alpnProtocols, Socket socket, InetSocketAddress address) {
        this.checkEnabled();
        try {
            SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, address.getHostName(), address.getPort(), true);
            SSLParameters parameters = new SSLParameters();
            parameters.setApplicationProtocols(alpnProtocols.toArray(new String[0]));
            parameters.setServerNames(this.sslParameters.getServerNames());
            parameters.setCipherSuites(this.sslParameters.getCipherSuites());
            parameters.setAlgorithmConstraints(this.sslParameters.getAlgorithmConstraints());
            parameters.setEnableRetransmissions(this.sslParameters.getEnableRetransmissions());
            parameters.setEndpointIdentificationAlgorithm(this.sslParameters.getEndpointIdentificationAlgorithm());
            parameters.setMaximumPacketSize(this.sslParameters.getMaximumPacketSize());
            parameters.setNamedGroups(this.sslParameters.getNamedGroups());
            parameters.setNeedClientAuth(this.sslParameters.getNeedClientAuth());
            parameters.setProtocols(this.sslParameters.getProtocols());
            parameters.setSignatureSchemes(this.sslParameters.getSignatureSchemes());
            parameters.setSNIMatchers(this.sslParameters.getSNIMatchers());
            parameters.setUseCipherSuitesOrder(this.sslParameters.getUseCipherSuitesOrder());
            parameters.setWantClientAuth(this.sslParameters.getWantClientAuth());
            sslSocket.setSSLParameters(this.sslParameters);
            return sslSocket;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SSLContext sslContext() {
        this.checkEnabled();
        return this.sslContext;
    }

    public SSLParameters sslParameters() {
        return this.sslParameters;
    }

    public void reload(Tls tls) {
        if (this.enabled) {
            this.tlsManager.reload(tls);
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    Optional<X509KeyManager> keyManager() {
        return this.tlsManager.keyManager();
    }

    Optional<X509TrustManager> trustManager() {
        return this.tlsManager.trustManager();
    }

    private static int hashCode(SSLParameters first) {
        int result = Objects.hash(first.getAlgorithmConstraints(), first.getEnableRetransmissions(), first.getEndpointIdentificationAlgorithm(), first.getMaximumPacketSize(), first.getNeedClientAuth(), first.getUseCipherSuitesOrder(), first.getWantClientAuth(), first.getServerNames(), first.getSNIMatchers());
        result = 31 * result + Arrays.hashCode(first.getApplicationProtocols());
        result = 31 * result + Arrays.hashCode(first.getCipherSuites());
        result = 31 * result + Arrays.hashCode(first.getProtocols());
        return result;
    }

    private static boolean equals(SSLParameters first, SSLParameters second) {
        return first.getAlgorithmConstraints().equals(second.getAlgorithmConstraints()) && Arrays.equals(first.getApplicationProtocols(), second.getApplicationProtocols()) && Arrays.equals(first.getCipherSuites(), second.getCipherSuites()) && first.getEnableRetransmissions() == second.getEnableRetransmissions() && Objects.equals(first.getEndpointIdentificationAlgorithm(), second.getEndpointIdentificationAlgorithm()) && first.getMaximumPacketSize() == second.getMaximumPacketSize() && first.getNeedClientAuth() == second.getNeedClientAuth() && Arrays.equals(first.getProtocols(), second.getProtocols()) && first.getUseCipherSuitesOrder() == second.getUseCipherSuitesOrder() && first.getWantClientAuth() == second.getWantClientAuth() && first.getServerNames().equals(second.getServerNames()) && first.getSNIMatchers().equals(second.getSNIMatchers());
    }

    private void checkEnabled() {
        if (this.sslContext == null) {
            throw new IllegalStateException("TLS config is disabled, SSL related methods cannot be called.");
        }
    }
}

